/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.items;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.ItemStackTools;
import mcjty.lib.varia.TagTools;
import mcjty.xnet.compat.ForestrySupport;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemFilterCache {
    private final boolean matchDamage;
    private final boolean tagsMode;
    private final boolean blacklistMode;
    private final boolean nbtMode;
    private final ItemStackList stacks;
    private final Set<TagKey<Item>> tagMatches = new HashSet<TagKey<Item>>();

    public ItemFilterCache(boolean matchDamage, boolean tagsMode, boolean blacklistMode, boolean nbtMode, @Nonnull ItemStackList stacks) {
        this.matchDamage = matchDamage;
        this.tagsMode = tagsMode;
        this.blacklistMode = blacklistMode;
        this.nbtMode = nbtMode;
        this.stacks = stacks;
        for (ItemStack s : stacks) {
            ItemStackTools.addCommonTags((Collection)TagTools.getTags((Item)s.m_41720_()), this.tagMatches);
        }
    }

    public boolean match(ItemStack stack) {
        if (!stack.m_41619_()) {
            boolean match = false;
            if (this.tagsMode) {
                Collection tags = TagTools.getTags((Item)stack.m_41720_());
                if (tags.isEmpty()) {
                    match = this.itemMatches(stack);
                } else if (!Collections.disjoint(this.tagMatches, tags)) {
                    match = true;
                }
            } else {
                match = this.itemMatches(stack);
            }
            return match != this.blacklistMode;
        }
        return false;
    }

    private boolean itemMatches(ItemStack stack) {
        if (this.stacks != null) {
            int forestryFlags = ForestrySupport.Tag.GEN.getFlag() | ForestrySupport.Tag.IS_ANALYZED.getFlag();
            ItemStack cleanedStack = null;
            if (this.nbtMode && ForestrySupport.isLoaded() && ForestrySupport.isBreedable(stack)) {
                cleanedStack = ForestrySupport.sanitize(stack, forestryFlags);
            }
            for (ItemStack itemStack : this.stacks) {
                ItemStack cleanedItemStack;
                if (this.matchDamage && itemStack.m_41773_() != stack.m_41773_() || this.nbtMode && (cleanedStack == null || !ForestrySupport.isBreedable(itemStack) ? !ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)stack) : !ItemStack.m_150942_((ItemStack)(cleanedItemStack = ForestrySupport.sanitize(itemStack, forestryFlags)), (ItemStack)cleanedStack)) || !itemStack.m_41720_().equals(stack.m_41720_())) continue;
                return true;
            }
        }
        return false;
    }
}

