/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.ponderjs.util;

import com.almostreliable.ponderjs.PonderJS;
import com.almostreliable.ponderjs.util.PonderErrorHelper;
import com.almostreliable.ponderjs.util.PonderPlatform;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.ponder.PonderTag;
import com.simibubi.create.foundation.ponder.Selection;
import dev.latvian.mods.kubejs.block.predicate.BlockIDPredicate;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class Util {
    public static Selection selectionOf(@Nullable Object o) {
        if (o instanceof Selection) {
            Selection s = (Selection)o;
            return s;
        }
        if (o instanceof BoundingBox) {
            BoundingBox box = (BoundingBox)o;
            return Selection.of((BoundingBox)box);
        }
        if (o instanceof BlockPos) {
            BlockPos b = (BlockPos)o;
            return Selection.of((BoundingBox)new BoundingBox(b));
        }
        if (o instanceof List) {
            List l = (List)o;
            if (l.stream().anyMatch(Objects::isNull)) {
                ConsoleJS.CLIENT.warn((Object)"Selection was provided as list with invalid values. This may happen if a comma is missing. Please check your code.");
            }
            if (l.size() == 2) {
                UtilsJS.vec3Of(l.get(0));
                Vec3 from = UtilsJS.vec3Of(l.get(0));
                Vec3 to = UtilsJS.vec3Of(l.get(1));
                return Selection.of((BoundingBox)new BoundingBox((int)from.f_82479_, (int)from.f_82480_, (int)from.f_82481_, (int)to.f_82479_, (int)to.f_82480_, (int)to.f_82481_));
            }
            Integer[] values = (Integer[])l.stream().map(entry -> UtilsJS.parseInt((Object)entry, (int)0)).toArray(Integer[]::new);
            if (values.length == 6) {
                return Selection.of((BoundingBox)new BoundingBox(values[0].intValue(), values[1].intValue(), values[2].intValue(), values[3].intValue(), values[4].intValue(), values[5].intValue()));
            }
            if (values.length == 3) {
                return Selection.of((BoundingBox)new BoundingBox(values[0].intValue(), values[1].intValue(), values[2].intValue(), values[0].intValue(), values[1].intValue(), values[2].intValue()));
            }
        }
        Vec3 v = UtilsJS.vec3Of((Object)o);
        return Selection.of((BoundingBox)new BoundingBox(new BlockPos((int)v.f_82479_, (int)v.f_82480_, (int)v.f_82481_)));
    }

    public static AllIcons allIconsOf(@Nullable Object o) {
        if (o instanceof AllIcons) {
            return (AllIcons)o;
        }
        if (o == null) {
            return AllIcons.I_ACTIVE;
        }
        return PonderJS.getIconByName(o.toString());
    }

    public static PonderTag ponderTagOf(@Nullable Object o) {
        Objects.requireNonNull(o);
        PonderTag ponderTag = PonderJS.getTagByName(o.toString()).orElse(null);
        if (ponderTag == null) {
            IllegalArgumentException e = new IllegalArgumentException("Invalid PonderTag: " + o);
            PonderErrorHelper.yeet(e);
            throw e;
        }
        return ponderTag;
    }

    public static BlockIDPredicate createBlockID(BlockState state) {
        BlockIDPredicate predicate = new BlockIDPredicate(PonderPlatform.getBlockName(state.m_60734_()));
        for (Map.Entry entry : state.m_61148_().entrySet()) {
            predicate.with(((Property)entry.getKey()).m_61708_(), ((Comparable)entry.getValue()).toString());
        }
        return predicate;
    }

    public static BlockState blockStateOf(@Nullable Object o) {
        Block block;
        CharSequence s;
        ResourceLocation location;
        if (o instanceof BlockState) {
            BlockState blockState = (BlockState)o;
            return blockState;
        }
        if (o instanceof Block) {
            Block block2 = (Block)o;
            return block2.m_49966_();
        }
        if (o instanceof BlockIDPredicate) {
            BlockIDPredicate predicate = (BlockIDPredicate)o;
            return predicate.getBlockState();
        }
        if (o instanceof CharSequence && (location = ResourceLocation.m_135820_((String)(s = (CharSequence)o).toString())) != null && (block = (Block)ForgeRegistries.BLOCKS.getValue(location)) != null) {
            return block.m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }
}

