/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.tile;

import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfigData;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CowJarBlockEntity
extends MilkJarBlockEntity
implements IMutableNameable {
    private static final int UPDATE_INTERVAL = 20;
    private boolean isDirty;
    private int ticksSinceUpdate;
    private Component customName;
    private boolean compressedCow;

    public CowJarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends MilkJarBlockEntity>)((BlockEntityType)ModBlockEntities.cowJar.get()), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tag.m_128461_("CustomName"));
        }
        this.compressedCow = tag.m_128471_("CompressedCow");
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.customName != null) {
            tag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        tag.m_128379_("CompressedCow", this.compressedCow);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CowJarBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.milkTank.getAmount() < 32000) {
            CookingForBlockheadsConfigData config = CookingForBlockheadsConfig.getActive();
            int milkToAdd = config.cowJarMilkPerTick;
            if (this.compressedCow) {
                milkToAdd = (int)((double)milkToAdd * config.compressedCowJarMilkMultiplier);
            }
            this.milkTank.fill(Compat.getMilkFluid(), milkToAdd, false);
            this.isDirty = true;
        }
        ++this.ticksSinceUpdate;
        if (this.isDirty && this.ticksSinceUpdate > 20) {
            this.sync();
            this.ticksSinceUpdate = 0;
            this.isDirty = false;
        }
    }

    public boolean isCompressedCow() {
        return this.compressedCow;
    }

    public void setCompressedCow(boolean compressedCow) {
        this.compressedCow = compressedCow;
    }

    @Override
    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    @Override
    public Component getDefaultName() {
        if (this.compressedCow) {
            return Component.m_237115_((String)"container.cookingforblockheads.cow_jar_compressed");
        }
        return Component.m_237115_((String)"container.cookingforblockheads.cow_jar");
    }
}

