/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.mixin.accessors.client.GuiSubtitleOverlayAccess;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.RegistryObject;

public class MultiblockSound
extends AbstractTickableSoundInstance {
    private final BooleanSupplier active;
    private final BooleanSupplier valid;
    private final float maxVolume;
    private long subtitleMillis;

    public MultiblockSound(BooleanSupplier active, BooleanSupplier valid, Vec3 pos, SoundEvent sound, boolean loop, float maxVolume) {
        super(sound, SoundSource.BLOCKS, SoundInstance.m_235150_());
        this.active = active;
        this.valid = valid;
        this.f_119575_ = pos.f_82479_;
        this.f_119576_ = pos.f_82480_;
        this.f_119577_ = pos.f_82481_;
        this.f_119578_ = loop;
        this.f_119573_ = 0.0f;
        this.maxVolume = maxVolume;
        this.subtitleMillis = Util.m_137550_();
    }

    public static BooleanSupplier startSound(BooleanSupplier active, BooleanSupplier valid, Vec3 pos, RegistryObject<SoundEvent> sound, float maxVolume) {
        return MultiblockSound.startSound(active, valid, pos, sound, true, maxVolume);
    }

    public static BooleanSupplier startSound(BooleanSupplier active, BooleanSupplier valid, Vec3 pos, RegistryObject<SoundEvent> sound, boolean loop, float maxVolume) {
        MultiblockSound instance = new MultiblockSound(active, valid, pos, (SoundEvent)sound.get(), loop, maxVolume);
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        soundManager.m_120367_((SoundInstance)instance);
        return () -> soundManager.m_120403_((SoundInstance)instance);
    }

    public boolean m_7784_() {
        return true;
    }

    public void m_7788_() {
        if (!this.valid.getAsBoolean()) {
            this.m_119609_();
        } else if (this.active.getAsBoolean()) {
            long currentMillis = Util.m_137550_();
            if (currentMillis - this.subtitleMillis > 1000L) {
                SoundManager soundManager = Minecraft.m_91087_().m_91106_();
                WeighedSoundEvents weighedsoundevents = this.m_6775_(soundManager);
                if (weighedsoundevents != null) {
                    ((GuiSubtitleOverlayAccess)ClientUtils.mc().f_91065_).getSubtitleOverlay().m_6985_((SoundInstance)this, weighedsoundevents);
                }
                this.subtitleMillis = currentMillis;
            }
            this.f_119573_ = this.maxVolume;
        } else {
            this.f_119573_ = 0.0f;
        }
    }
}

