/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slope;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.CommonShapes;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;
import xfacthd.framedblocks.common.data.shapes.slope.SlopeShapes;

public final class VerticalHalfSlopeShapes
implements SplitShapeGenerator {
    public static final ShapeCache<Boolean> SHAPES = ShapeCache.createIdentity(map -> {
        map.put(Boolean.FALSE, ShapeUtils.andUnoptimized(SlopeShapes.SHAPES.get(SlopeType.HORIZONTAL), CommonShapes.SLAB.get(Boolean.FALSE)));
        map.put(Boolean.TRUE, ShapeUtils.andUnoptimized(SlopeShapes.SHAPES.get(SlopeType.HORIZONTAL), CommonShapes.SLAB.get(Boolean.TRUE)));
    });
    public static final ShapeCache<Boolean> OCCLUSION_SHAPES = ShapeCache.createIdentity(map -> {
        map.put(Boolean.FALSE, ShapeUtils.andUnoptimized(SlopeShapes.OCCLUSION_SHAPES.get(SlopeType.HORIZONTAL), CommonShapes.SLAB.get(Boolean.FALSE)));
        map.put(Boolean.TRUE, ShapeUtils.andUnoptimized(SlopeShapes.OCCLUSION_SHAPES.get(SlopeType.HORIZONTAL), CommonShapes.SLAB.get(Boolean.TRUE)));
    });

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return VerticalHalfSlopeShapes.generateShapes(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return VerticalHalfSlopeShapes.generateShapes(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generateShapes(ImmutableList<BlockState> states, ShapeCache<Boolean> shapeCache) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape[] shapes = ShapeUtils.makeHorizontalRotationsWithFlag(shapeCache.get(Boolean.FALSE), shapeCache.get(Boolean.TRUE), Direction.NORTH);
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            boolean top = (Boolean)state.m_61143_((Property)FramedProperties.TOP);
            builder.put((Object)state, (Object)shapes[dir.m_122416_() + (top ? 4 : 0)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

