/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;

public final class CullingHelper {
    private static final BlockState AIR = Blocks.f_50016_.m_49966_();

    public static boolean isSideHidden(BlockGetter level, BlockPos pos, BlockState state, Direction side) {
        IFramedBlock block;
        BlockPos adjPos = pos.m_121945_(side);
        BlockState adjState = level.m_8055_(adjPos);
        boolean adjFramed = false;
        IFramedBlock adjBlock = null;
        Block block2 = adjState.m_60734_();
        if (block2 instanceof IFramedBlock) {
            block = (IFramedBlock)block2;
            if (block.shouldPreventNeighborCulling(level, adjPos, adjState, pos, state)) {
                return false;
            }
            adjFramed = true;
            adjBlock = block;
        } else if (adjState.m_60804_(level, adjPos)) {
            return false;
        }
        block = (IFramedBlock)state.m_60734_();
        boolean fullFace = block.getCache(state).isFullFace(side);
        if (!adjFramed || fullFace || !FramedBlocksAPI.getInstance().detailedCullingEnabled()) {
            if (fullFace && (!adjFramed || adjBlock.getCache(adjState).isFullFace(side.m_122424_()))) {
                return CullingHelper.compareState(level, pos, adjPos, adjState, adjFramed, side);
            }
            return false;
        }
        SideSkipPredicate pred = block.getBlockType().getSideSkipPredicate();
        BlockState adjTestState = adjBlock.runOcclusionTestAndGetLookupState(pred, level, pos, state, adjState, side);
        if (adjTestState != null) {
            return CullingHelper.compareState(level, pos, side, state, adjTestState);
        }
        return false;
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, BlockPos adjPos, BlockState adjState, boolean adjFramed, Direction side) {
        BlockState adjCamoState = adjState;
        if (adjFramed) {
            BlockEntity blockEntity = level.m_7702_(adjPos);
            if (!(blockEntity instanceof FramedBlockEntity)) {
                return false;
            }
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            adjCamoState = be.getCamo(side.m_122424_()).getState();
        }
        BlockState camoState = AIR;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            camoState = be.getCamo(side).getState();
        }
        return CullingHelper.compareState(level, pos, camoState, adjCamoState, side);
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, Direction side, BlockState testState, BlockState adjTestState) {
        FramedBlockEntity be;
        BlockState adjCamoState = AIR;
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(side));
        if (blockEntity instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            adjCamoState = be.getCamo(adjTestState).getState();
        }
        if (!adjCamoState.m_60795_() && (blockEntity = level.m_7702_(pos)) instanceof FramedBlockEntity) {
            be = (FramedBlockEntity)blockEntity;
            BlockState camoState = be.getCamo(testState).getState();
            return CullingHelper.compareState(level, pos, camoState, adjCamoState, side);
        }
        return false;
    }

    public static boolean compareState(BlockGetter level, BlockPos pos, BlockState camoState, BlockState adjCamoState, Direction side) {
        if (camoState.m_60795_() || adjCamoState.m_60795_()) {
            return false;
        }
        if (camoState == adjCamoState) {
            return FramedBlocksAPI.getInstance().canCullBlockNextTo(camoState, adjCamoState);
        }
        return adjCamoState.m_60804_(level, pos.m_121945_(side));
    }

    public static boolean hidesNeighborFace(IFramedBlock block, BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (!FramedBlocksAPI.getInstance().canHideNeighborFaceInLevel(level) || adjState.m_60734_() instanceof IFramedBlock) {
            return false;
        }
        if (block.shouldPreventNeighborCulling(level, pos, state, pos.m_121945_(side), adjState)) {
            return false;
        }
        if (CullingHelper.doesFullFaceOccludeWithCamo(level, pos, state, adjState, side)) {
            return true;
        }
        BlockEntity blockEntity = level.getExistingBlockEntity(pos);
        if (blockEntity instanceof FramedBlockEntity) {
            FramedBlockEntity be = (FramedBlockEntity)blockEntity;
            return be.isSolidSide(side) && !be.isIntangible(null);
        }
        return false;
    }

    private static boolean doesFullFaceOccludeWithCamo(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (!(adjState.m_60734_() instanceof HalfTransparentBlock)) {
            return false;
        }
        if (((IFramedBlock)state.m_60734_()).getCache(state).isFullFace(side)) {
            return CullingHelper.compareState(level, pos, pos.m_121945_(side), adjState, false, side);
        }
        return false;
    }

    private CullingHelper() {
    }
}

