/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import com.mojang.datafixers.util.Either;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftbquests.net.SyncStructuresRequestMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.AbstractBooleanTask;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StructureTask
extends AbstractBooleanTask {
    private static final ResourceLocation DEFAULT_STRUCTURE = new ResourceLocation("minecraft:mineshaft");
    private static final List<String> KNOWN_STRUCTURES = new ArrayList<String>();
    private Either<ResourceKey<Structure>, TagKey<Structure>> structure = Either.left((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)DEFAULT_STRUCTURE));

    public StructureTask(long id, Quest quest) {
        super(id, quest);
    }

    public static void syncKnownStructureList(List<String> data) {
        KNOWN_STRUCTURES.clear();
        KNOWN_STRUCTURES.addAll(data);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STRUCTURE;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("structure", this.getStructure());
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.setStructure(nbt.m_128461_("structure"));
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130070_(this.getStructure());
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.setStructure(buffer.m_130136_(1024));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        if (KNOWN_STRUCTURES.isEmpty()) {
            config.addString("structure", this.getStructure(), this::setStructure, "minecraft:mineshaft");
        } else {
            config.addEnum("structure", (Object)this.getStructure(), this::setStructure, NameMap.of((Object)DEFAULT_STRUCTURE.toString(), KNOWN_STRUCTURES).create());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return Component.m_237115_((String)"ftbquests.task.ftbquests.structure").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)this.getStructure()).m_130940_(ChatFormatting.DARK_GREEN));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean checkOnLogin() {
        return false;
    }

    @Override
    public boolean canSubmit(TeamData teamData, ServerPlayer player) {
        if (player.m_5833_()) {
            return false;
        }
        ServerLevel level = (ServerLevel)player.m_9236_();
        return (Boolean)this.structure.map(key -> level.m_215010_().m_220488_(player.m_20183_(), key).m_73603_(), tag -> level.m_215010_().m_220491_(player.m_20183_(), tag).m_73603_());
    }

    private void setStructure(String resLoc) {
        this.structure = resLoc.startsWith("#") ? Either.right((Object)TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)this.safeResourceLocation(resLoc.substring(1), DEFAULT_STRUCTURE))) : Either.left((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)this.safeResourceLocation(resLoc, DEFAULT_STRUCTURE)));
    }

    private String getStructure() {
        return (String)this.structure.map(key -> key.m_135782_().toString(), tag -> "#" + String.valueOf(tag.f_203868_()));
    }

    public static void maybeRequestStructureSync() {
        if (KNOWN_STRUCTURES.isEmpty()) {
            new SyncStructuresRequestMessage().sendToServer();
        }
    }
}

