/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.ManaKey;
import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import com.google.common.base.Predicates;
import com.google.common.primitives.Ints;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class ManaGenericStackInvStorage
implements ManaReceiver,
ManaPool,
SparkAttachable {
    private final Level level;
    private final BlockPos pos;
    private final GenericInternalInventory inv;

    public ManaGenericStackInvStorage(GenericInternalInventory inv, Level level, BlockPos pos) {
        this.inv = inv;
        this.level = level;
        this.pos = pos;
    }

    public Level getManaReceiverLevel() {
        return this.level;
    }

    public BlockPos getManaReceiverPos() {
        return this.pos;
    }

    public int getCurrentMana() {
        return this.extract(Integer.MAX_VALUE, Actionable.SIMULATE);
    }

    public boolean isFull() {
        return this.insert(1, Actionable.SIMULATE) != 0;
    }

    public void receiveMana(int mana) {
        if (mana > 0) {
            this.insert(mana, Actionable.MODULATE);
        } else if (mana < 0) {
            this.extract(-mana, Actionable.MODULATE);
        }
    }

    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public int getMaxMana() {
        int slots = 0;
        for (int i = 0; i < this.inv.size(); ++i) {
            AEKey key = this.inv.getKey(i);
            if (key != null && key != ManaKey.KEY) continue;
            ++slots;
        }
        return Ints.saturatedCast((long)((long)slots * this.inv.getMaxAmount(ManaKey.KEY)));
    }

    public Optional<DyeColor> getColor() {
        return Optional.of(DyeColor.PURPLE);
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public boolean canAttachSpark(ItemStack stack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        return this.insert(Integer.MAX_VALUE, Actionable.SIMULATE);
    }

    public ManaSpark getAttachedSpark() {
        BlockPos sparkPos = this.pos.m_7494_();
        List sparks = this.level.m_6443_(Entity.class, new AABB(sparkPos, sparkPos.m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            return (ManaSpark)sparks.get(0);
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return !this.isFull();
    }

    public int insert(int amount, Actionable actionable) {
        long inserted = 0L;
        for (int i = 0; i < this.inv.size() && inserted < (long)amount; inserted += this.inv.insert(i, ManaKey.KEY, (long)amount - inserted, actionable), ++i) {
        }
        return (int)inserted;
    }

    private int extract(int amount, Actionable actionable) {
        long extracted = 0L;
        for (int i = 0; i < this.inv.size() && extracted < (long)amount; extracted += this.inv.extract(i, ManaKey.KEY, (long)amount - extracted, actionable), ++i) {
        }
        return (int)extracted;
    }
}

