/*
 * Decompiled with CFR 0.152.
 */
package com.Pdiddy973.AllTheCompressed.data;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.StringDecomposer;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.ModList;

public class LanguageUtil {
    private final Map<String, Language> languageMap = new HashMap<String, Language>();
    private final ExistingFileHelper fileHelper;

    public LanguageUtil(ExistingFileHelper fileHelper) {
        this.fileHelper = fileHelper;
        this.languageMap.put("minecraft", Language.m_128107_());
    }

    public String getParentName(ResourceLocation parent) {
        String translationKey = String.format("block.%s.%s", parent.m_135827_(), parent.m_135815_());
        return this.getLanguage(parent.m_135827_()).m_6834_(translationKey);
    }

    private Language getLanguage(String mod) {
        if (!ModList.get().isLoaded(mod)) {
            throw new IllegalArgumentException("Mod is not loaded: " + mod);
        }
        return this.languageMap.computeIfAbsent(mod, this::loadLanguage);
    }

    private Language loadLanguage(String mod) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String langFile = String.format("/assets/%s/lang/en_us.json", mod);
        try {
            Resource resource = this.fileHelper.getResource(new ResourceLocation(mod, "/lang/en_us.json"), PackType.CLIENT_RESOURCES);
            InputStream is = resource.m_215507_();
            Language.m_128108_((InputStream)is, (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to load file: %s", langFile), e);
        }
        final HashMap map = new HashMap(builder.build());
        return new Language(){

            public String m_118919_(String key, String fallback) {
                return map.getOrDefault(key, fallback);
            }

            public boolean m_6722_(String key) {
                return map.containsKey(key);
            }

            public boolean m_6627_() {
                return false;
            }

            public FormattedCharSequence m_5536_(FormattedText formattedText) {
                return sink -> formattedText.m_7451_((style, text) -> StringDecomposer.m_14346_((String)text, (Style)style, (FormattedCharSink)sink) ? Optional.empty() : FormattedText.f_130759_, Style.f_131099_).isPresent();
            }

            public Map<String, String> getLanguageData() {
                return map;
            }
        };
    }
}

