/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.TooltipHelper;
import giselle.jei_mekanism_multiblocks.client.gui.CheckBoxWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.jei.CostWidget;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import java.util.function.Consumer;
import mekanism.api.math.MathUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismGases;
import mekanism.common.util.HeatUtils;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class BoilerCategory
extends MultiblockCategory<BoilerWidget> {
    public BoilerCategory(IGuiHelper helper) {
        super(helper, Mekanism.rl((String)"boiler"), BoilerWidget.class, (Component)MekanismLang.BOILER.translate(new Object[0]), MekanismBlocks.BOILER_VALVE.getItemStack());
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(MekanismBlocks.BOILER_CASING.getItemStack());
        consumer.accept(MekanismBlocks.BOILER_VALVE.getItemStack());
        consumer.accept(MekanismBlocks.PRESSURE_DISPERSER.getItemStack());
        consumer.accept(MekanismBlocks.SUPERHEATING_ELEMENT.getItemStack());
        consumer.accept(MekanismBlocks.STRUCTURAL_GLASS.getItemStack());
    }

    public static class BoilerWidget
    extends MultiblockWidget {
        protected CheckBoxWidget forSodiumCoolingCheckBox;
        protected IntSliderWithButtons valvesWidget;
        protected IntSliderWithButtons steamHeightWidget;
        protected IntSliderWithButtons heatingElementsWidget;
        private boolean needMoreHeatingElements;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.forSodiumCoolingCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.specs.for_sodium_cooling"), false);
            consumer.accept((AbstractWidget)this.forSodiumCoolingCheckBox);
            this.forSodiumCoolingCheckBox.addSelectedChangedHandler(this::onForSodiumCoolingChanged);
            this.valvesWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.valves", 0, 0, 0);
            consumer.accept(this.valvesWidget);
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).addValueChangeHanlder(this::onValvesChanged);
            this.steamHeightWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.steam_height", 0, 1, 0);
            consumer.accept(this.steamHeightWidget);
            ((IntSliderWidget)((Object)this.steamHeightWidget.getSlider())).addValueChangeHanlder(this::onSteamHeightChanged);
            this.steamHeightWidget.m_257544_(TooltipHelper.createMessageOnly(new Component[]{Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.steam_height", (Object[])new Object[]{MekanismBlocks.PRESSURE_DISPERSER.getTextComponent()})}));
            this.heatingElementsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.heating_elements", 0, 1, 0);
            consumer.accept(this.heatingElementsWidget);
            ((IntSliderWidget)((Object)this.heatingElementsWidget.getSlider())).addValueChangeHanlder(this::onHeatingElementsChanged);
            this.updateSlidersLimit();
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updateSlidersLimit();
            if (this.isForSodiumCooling()) {
                this.calculatePreferredSodiumCoolingLayout();
            }
        }

        public void calculatePreferredSodiumCoolingLayout() {
            IntSliderWidget steamHeightSlider = (IntSliderWidget)((Object)this.steamHeightWidget.getSlider());
            IntSliderWidget heatingElementsSlider = (IntSliderWidget)((Object)this.heatingElementsWidget.getSlider());
            double maxBoil = 0.0;
            int preferredSteamHeight = 0;
            int preferredHeatingElementCount = 0;
            int steamHeight = steamHeightSlider.getMinValue();
            int heatingElementCount = heatingElementsSlider.getMinValue();
            while (steamHeight <= steamHeightSlider.getMaxValue() && heatingElementCount <= this.getMaxHeatingElements(steamHeight)) {
                BoilerCoolingSimulation simulation = this.simulateSodiumCooling(steamHeight, heatingElementCount);
                if ((double)simulation.boilRate > maxBoil) {
                    maxBoil = simulation.boilRate;
                    preferredSteamHeight = steamHeight;
                    preferredHeatingElementCount = heatingElementCount;
                }
                if (simulation.needMoreSuperHeatingElements) {
                    ++heatingElementCount;
                    continue;
                }
                if (!simulation.needMoreSteamVolume) break;
                ++steamHeight;
            }
            if (preferredSteamHeight > 0) {
                this.setSteamHeight(preferredSteamHeight);
                this.SetHeatingElementCount(preferredHeatingElementCount);
            }
        }

        public void updateSlidersLimit() {
            IntSliderWidget valvesSlider = (IntSliderWidget)((Object)this.valvesWidget.getSlider());
            int minValves = valvesSlider.getMinValue();
            int valves = valvesSlider.getValue();
            valvesSlider.setMinValue(this.isForSodiumCooling() ? 4 : 2);
            valvesSlider.setMaxValue(this.getSideBlocks());
            valvesSlider.setValue(valves + (valvesSlider.getMinValue() - minValves));
            IntSliderWidget steamHeightSlider = (IntSliderWidget)((Object)this.steamHeightWidget.getSlider());
            int steamHeight = steamHeightSlider.getValue();
            steamHeightSlider.setMaxValue(this.getInnerAdjustableHeight() + steamHeightSlider.getMinValue());
            steamHeightSlider.setValue(steamHeight);
            this.updateHeatingHeightSliderLimit();
        }

        protected void onValvesChanged(int valves) {
            this.markNeedUpdate();
        }

        protected void onSteamHeightChanged(int height) {
            this.updateHeatingHeightSliderLimit();
            this.markNeedUpdate();
        }

        public void updateHeatingHeightSliderLimit() {
            IntSliderWidget heatingElementsSlider = (IntSliderWidget)((Object)this.heatingElementsWidget.getSlider());
            int heatingElements = heatingElementsSlider.getValue();
            heatingElementsSlider.setMaxValue(this.getMaxHeatingElements(this.getSteamHeight()));
            heatingElementsSlider.setValue(heatingElements);
        }

        public int getMaxHeatingElements(int steamHeight) {
            Vec3i inner = this.getDimensionInner();
            return (this.getInnerAdjustableHeight() - steamHeight + 2) * (inner.m_123341_() * inner.m_123343_());
        }

        protected void onHeatingElementsChanged(int elements) {
            this.markNeedUpdate();
        }

        protected void onForSodiumCoolingChanged(boolean forSodiumCooling) {
            this.updateSlidersLimit();
            if (forSodiumCooling) {
                this.calculatePreferredSodiumCoolingLayout();
            }
            this.markNeedUpdate();
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int valves = this.getValveCount();
            sides -= valves;
            int casing = 0;
            int glasses = 0;
            if (this.isUseGlass()) {
                casing = corners;
                glasses = sides;
            } else {
                casing = corners + sides;
            }
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.BOILER_CASING, casing));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.BOILER_VALVE, valves));
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.PRESSURE_DISPERSER, this.getPressureDispenserCount()));
            CostWidget heatingElements = consumer.accept(new ItemStack((ItemLike)MekanismBlocks.SUPERHEATING_ELEMENT, this.getHeatingElementCount()));
            if (this.needMoreHeatingElements) {
                heatingElements.setFGColor(0xFF8000);
                heatingElements.setHeadTooltip(new Component[]{Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.value_limited", (Object[])new Object[]{Component.m_237110_((String)"text.jei_mekanism_multiblocks.result.boil_rate_with", (Object[])new Object[]{new FluidStack((Fluid)Fluids.f_76193_, 1).getDisplayName()})}).m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_more", (Object[])new Object[]{MekanismBlocks.SUPERHEATING_ELEMENT.getTextComponent()}).m_130940_(ChatFormatting.RED)});
            }
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            int steamHeight = this.getSteamHeight();
            int heatingElementCount = this.getHeatingElementCount();
            if (this.isForSodiumCooling()) {
                BoilerCoolingSimulation simulation = this.simulateSodiumCooling(steamHeight, heatingElementCount);
                ResultWidget boilRateWidget = new ResultWidget((Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.result.boil_rate_with", (Object[])new Object[]{new FluidStack((Fluid)Fluids.f_76193_, 1).getDisplayName()}), VolumeTextHelper.formatMBt(simulation.boilRate));
                ResultWidget coolingRateWidget = new ResultWidget((Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.result.cooling_rate_with", (Object[])new Object[]{MekanismGases.SODIUM.getTextComponent()}), VolumeTextHelper.formatMBt(simulation.coolingRate));
                this.needMoreHeatingElements = false;
                if (simulation.needMoreSuperHeatingElements) {
                    IntSliderWidget heatingElementsSlider = (IntSliderWidget)((Object)this.heatingElementsWidget.getSlider());
                    int testHeatingElementCount = Math.min(heatingElementCount + 1, heatingElementsSlider.getMaxValue());
                    BoilerCoolingSimulation simulation2 = this.simulateSodiumCooling(steamHeight, testHeatingElementCount);
                    if (simulation2.boilRate > simulation.boilRate) {
                        this.needMoreHeatingElements = true;
                        boilRateWidget.getValueLabel().setFGColor(0xFF8000);
                        boilRateWidget.m_257544_(TooltipHelper.createMessageOnly(new Component[]{Component.m_237115_((String)"text.jei_mekanism_multiblocks.tooltip.limited").m_130940_(ChatFormatting.RED), Component.m_237110_((String)"text.jei_mekanism_multiblocks.tooltip.need_more", (Object[])new Object[]{MekanismBlocks.SUPERHEATING_ELEMENT.getTextComponent()}).m_130940_(ChatFormatting.RED)}));
                    }
                }
                consumer.accept(boilRateWidget);
                consumer.accept(coolingRateWidget);
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.water_tank"), VolumeTextHelper.formatMB(simulation.waterTank)));
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.steam_tank"), VolumeTextHelper.formatMB(simulation.steamTank)));
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.heated_coolant_tank"), VolumeTextHelper.formatMB(simulation.heatedCoolantTank)));
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.cooled_coolant_tank"), VolumeTextHelper.formatMB(simulation.cooledCoolantTank)));
            } else {
                int steamVolume = this.getSteamVolume(steamHeight);
                int waterVolume = this.getWaterVolume(steamHeight, heatingElementCount);
                double boilCapacity = MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.getHeatingElementCount() / HeatUtils.getWaterThermalEnthalpy();
                boilCapacity = MathUtils.clampToLong((double)(boilCapacity * HeatUtils.getSteamEnergyEfficiency()));
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.boil_capacity"), VolumeTextHelper.formatMBt(boilCapacity)));
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.water_tank"), VolumeTextHelper.formatMB(this.getWaterTank(waterVolume))));
                consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.steam_tank"), VolumeTextHelper.formatMB(this.getSteamTank(steamVolume))));
            }
        }

        public BoilerCoolingSimulation simulateSodiumCooling(int steamHeight, int heatingElementCount) {
            BoilerCoolingSimulation simulation = this.createSodiumCoolingSimulation(steamHeight, heatingElementCount, 0.4, MekanismGases.Coolants.HEATED_SODIUM_COOLANT.getThermalEnthalpy());
            simulation.cycleForStableBoil();
            return simulation;
        }

        public BoilerCoolingSimulation createSodiumCoolingSimulation(int steamHeight, int heatingElementCount, double coolantCoolingEfficiency, double coolantThermalEnthalpy) {
            int steamVolume = this.getSteamVolume(steamHeight);
            int waterVolume = this.getWaterVolume(steamHeight, heatingElementCount);
            BoilerCoolingSimulation simulation = new BoilerCoolingSimulation();
            simulation.heatCapacity = this.getHeatCapacity();
            simulation.steamTank = this.getSteamTank(steamVolume);
            simulation.heatedCoolantTank = this.getHeatedCoolantTank(waterVolume);
            simulation.waterTank = this.getWaterTank(waterVolume);
            simulation.cooledCoolantTank = this.getCooledCoolantTank(steamVolume);
            simulation.superHeatingElements = heatingElementCount;
            simulation.coolantCoolingEfficiency = coolantCoolingEfficiency;
            simulation.coolantThermalEnthalpy = coolantThermalEnthalpy;
            return simulation;
        }

        public double getHeatCapacity() {
            return 50.0 * (double)this.getDimensionCasingBlocks();
        }

        public int getWaterVolume(int steamHeight, int heatingElenmentCount) {
            Vec3i outer = this.getDimension();
            int outerSquare = outer.m_123341_() * outer.m_123343_();
            Vec3i inner = this.getDimensionInner();
            int innerSquare = inner.m_123341_() * inner.m_123343_();
            return outerSquare * inner.m_123342_() - (this.getSteamVolume(steamHeight) - outerSquare + innerSquare) - (heatingElenmentCount - innerSquare);
        }

        public int getSteamVolume(int steamHeight) {
            Vec3i outer = this.getDimension();
            return outer.m_123341_() * outer.m_123343_() * steamHeight;
        }

        public int getWaterTank(int waterVolume) {
            return waterVolume * MekanismConfig.general.boilerWaterPerTank.get();
        }

        public long getSteamTank(int steamVolume) {
            return (long)steamVolume * MekanismConfig.general.boilerSteamPerTank.get();
        }

        public long getHeatedCoolantTank(int steamVolume) {
            return (long)steamVolume * MekanismConfig.general.boilerHeatedCoolantPerTank.get();
        }

        public long getCooledCoolantTank(int waterVolume) {
            return (long)waterVolume * MekanismConfig.general.boilerCooledCoolantPerTank.get();
        }

        public int getPressureDispenserCount() {
            Vec3i inner = this.getDimensionInner();
            return inner.m_123341_() * inner.m_123343_();
        }

        public int getInnerAdjustableHeight() {
            return this.getDimensionInner().m_123342_() - 2;
        }

        public int getValveCount() {
            return ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).getValue();
        }

        public void setValveCount(int valveCount) {
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).setValue(valveCount);
        }

        public boolean isForSodiumCooling() {
            return this.forSodiumCoolingCheckBox.isSelected();
        }

        public void setForSodiumCooling(boolean forSodiumCooling) {
            this.forSodiumCoolingCheckBox.setSelected(forSodiumCooling);
        }

        public int getSteamHeight() {
            return ((IntSliderWidget)((Object)this.steamHeightWidget.getSlider())).getValue();
        }

        public void setSteamHeight(int height) {
            ((IntSliderWidget)((Object)this.steamHeightWidget.getSlider())).setValue(height);
        }

        public int getHeatingElementCount() {
            return ((IntSliderWidget)((Object)this.heatingElementsWidget.getSlider())).getValue();
        }

        public void SetHeatingElementCount(int heatingElementCount) {
            ((IntSliderWidget)((Object)this.heatingElementsWidget.getSlider())).setValue(heatingElementCount);
        }

        @Override
        public int getDimensionWidthMin() {
            return 3;
        }

        @Override
        public int getDimensionWidthMax() {
            return 18;
        }

        @Override
        public int getDimensionLengthMin() {
            return 3;
        }

        @Override
        public int getDimensionLengthMax() {
            return 18;
        }

        @Override
        public int getDimensionHeightMin() {
            return 4;
        }

        @Override
        public int getDimensionHeightMax() {
            return 18;
        }

        @Override
        public Block getGlassBlock() {
            return MekanismBlocks.STRUCTURAL_GLASS.getBlock();
        }
    }

    public static class BoilerCoolingSimulation {
        public double heatCapacity;
        public long heatedCoolantTank;
        public long cooledCoolantTank;
        public long waterTank;
        public long steamTank;
        public double coolantCoolingEfficiency;
        public double coolantThermalEnthalpy;
        public int superHeatingElements;
        public double heat;
        public double thermalHeat;
        public double boilHeat;
        public double heatOnTemp;
        public boolean needMoreSteamVolume;
        public boolean needMoreSuperHeatingElements;
        public long coolingRate;
        public long boilRate;

        public void reset() {
            this.heat = 300.0 * this.heatCapacity;
        }

        public void cycleForStableBoil() {
            this.reset();
            long prevBoil = -1L;
            while (true) {
                this.tick();
                if (prevBoil > -1L && prevBoil >= this.boilRate) break;
                prevBoil = this.boilRate;
            }
        }

        public void cycleForStableTemp() {
            this.reset();
            double prevHeat = -1.0;
            while (true) {
                this.tick();
                if (prevHeat > -1.0 && prevHeat >= this.heat) break;
                prevHeat = this.heat;
            }
        }

        public void tick() {
            double temp = this.heat / this.heatCapacity;
            this.coolingRate = Math.round((double)this.heatedCoolantTank * this.coolantCoolingEfficiency);
            this.coolingRate = MathUtils.clampToLong((double)((double)this.coolingRate * (1.0 - temp / 100000.0)));
            if (this.coolingRate > this.cooledCoolantTank) {
                this.coolingRate = this.cooledCoolantTank;
                this.needMoreSteamVolume = true;
            } else {
                this.needMoreSteamVolume = false;
            }
            this.thermalHeat = Math.max((double)this.coolingRate * this.coolantThermalEnthalpy, 0.0);
            if (this.thermalHeat > 0.0) {
                this.heat += this.thermalHeat;
            }
            double boilingHeat = this.heatOnTemp = (temp - HeatUtils.BASE_BOIL_TEMP) * (this.heatCapacity * MekanismConfig.general.boilerWaterConductivity.get());
            double heatingCapacity = MekanismConfig.general.superheatingHeatTransfer.get() * (double)this.superHeatingElements;
            if (this.heatOnTemp > heatingCapacity) {
                boilingHeat = heatingCapacity;
                this.needMoreSuperHeatingElements = true;
            } else {
                this.needMoreSuperHeatingElements = false;
            }
            this.boilRate = (int)Math.floor(HeatUtils.getSteamEnergyEfficiency() * boilingHeat / HeatUtils.getWaterThermalEnthalpy());
            this.boilRate = Math.min(this.boilRate, Math.min(this.waterTank, this.steamTank));
            this.boilHeat = (double)this.boilRate * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
            if (this.boilHeat > 0.0) {
                this.heat -= this.boilHeat;
            }
        }
    }
}

