/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.types;

import com.ldtteam.domumornamentum.block.types.ExtraBlockCategory;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ExtraBlockType implements StringRepresentable
{
    BLACK_BRICK(DyeColor.BLACK, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    BLUE_BRICK(DyeColor.BLUE, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    BLUE_SLATE(DyeColor.BLUE, Items.f_42594_, SoundType.f_56742_, ExtraBlockCategory.SLATE),
    BROWN_BRICK(DyeColor.BROWN, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    BASE_BRICK(null, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    CYAN_BRICK(DyeColor.CYAN, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    GRAY_BRICK(DyeColor.GRAY, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    GREEN_BRICK(DyeColor.GREEN, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    GREEN_SLATE(DyeColor.GREEN, Items.f_42594_, SoundType.f_56742_, ExtraBlockCategory.SLATE),
    LIGHT_BLUE_BRICK(DyeColor.LIGHT_BLUE, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    LIGHT_GRAY_BRICK(DyeColor.LIGHT_GRAY, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    LIME_BRICK(DyeColor.LIME, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    MAGENTA_BRICK(DyeColor.MAGENTA, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    MOSS_SLATE(null, Items.f_41998_, SoundType.f_56742_, ExtraBlockCategory.SLATE),
    ORANGE_BRICK(DyeColor.ORANGE, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    PINK_BRICK(DyeColor.PINK, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    PURPLE_BRICK(DyeColor.PURPLE, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    PURPLE_SLATE(DyeColor.PURPLE, Items.f_42594_, SoundType.f_56742_, ExtraBlockCategory.SLATE),
    RED_BRICK(DyeColor.RED, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    BASE_SLATE(null, Items.f_42594_, SoundType.f_56742_, ExtraBlockCategory.SLATE),
    BASE_THATCHED(null, Items.f_42405_, SoundType.f_56740_, ExtraBlockCategory.THATCHED),
    WHITE_BRICK(DyeColor.WHITE, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    YELLOW_BRICK(DyeColor.YELLOW, Items.f_42460_, SoundType.f_56742_, ExtraBlockCategory.BRICK),
    BASE_PAPER(null, Items.f_42516_, SoundType.f_56745_, ExtraBlockCategory.PAPER),
    BASE_CACTUS(null, Items.f_41982_, SoundType.f_56736_, ExtraBlockCategory.CACTUS),
    GREEN_CACTUS(DyeColor.GREEN, Items.f_41982_, SoundType.f_56736_, ExtraBlockCategory.CACTUS),
    LIGHT_PAPER(DyeColor.WHITE, Items.f_42516_, SoundType.f_56745_, ExtraBlockCategory.PAPER, true);

    private final DyeColor color;
    private final Item material;
    private final SoundType soundType;
    private final ExtraBlockCategory category;
    private final boolean isTranslucent;

    private ExtraBlockType(DyeColor color, Item material, SoundType soundType, ExtraBlockCategory category, boolean isTranslucent) {
        this.color = color;
        this.material = material;
        this.soundType = soundType;
        this.category = category;
        this.isTranslucent = isTranslucent;
    }

    private ExtraBlockType(DyeColor color, Item material, SoundType soundType, ExtraBlockCategory category) {
        this.color = color;
        this.material = material;
        this.soundType = soundType;
        this.category = category;
        this.isTranslucent = false;
    }

    @NotNull
    public String m_7912_() {
        return (String)(this.color == null ? "" : this.color.m_7912_() + "_") + ForgeRegistries.ITEMS.getKey((Object)this.material).m_135815_() + "_extra";
    }

    @Nullable
    public DyeColor getColor() {
        return this.color;
    }

    public Item getMaterial() {
        return this.material;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public ExtraBlockCategory getCategory() {
        return this.category;
    }

    public boolean isTranslucent() {
        return this.isTranslucent;
    }

    public BlockBehaviour.Properties adjustProperties(BlockBehaviour.Properties properties) {
        if (this.isTranslucent) {
            properties.m_60910_();
        }
        return properties;
    }
}

