/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.generatorgalore.util;

import com.mojang.datafixers.util.Pair;
import cy.jdkdigital.generatorgalore.GeneratorGalore;
import cy.jdkdigital.generatorgalore.common.block.entity.GeneratorBlockEntity;
import cy.jdkdigital.generatorgalore.util.GeneratorObject;
import cy.jdkdigital.generatorgalore.util.PotionUtil;
import cy.jdkdigital.generatorgalore.util.collection.SetMultiMap;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.ItemStackHandler;

public class GeneratorUtil {
    public static ResourceLocation EMPTY_TAG = new ResourceLocation("generatorgalore", "empty");
    public static String FUEL_SOLID = "SOLID";
    public static String FUEL_FLUID = "FLUID";
    public static String FUEL_FOOD = "FOOD";
    public static String FUEL_ENCHANTMENT = "ENCHANTMENT";
    public static final Path LOCK_FILE = GeneratorUtil.createCustomPath("");
    public static final Path GENERATORS = GeneratorUtil.createCustomPath("generators");

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "generatorgalore", pathName);
        GeneratorUtil.createDirectory(customPath, pathName);
        return customPath;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            GeneratorGalore.LOGGER.error("failed to create \"" + dirName + "\" directory");
        }
    }

    public static void replaceGenerator(Level level, BlockPos pos, GeneratorObject generator) {
        BlockState existingGenerator = level.m_8055_(pos);
        BlockState newGenerator = (BlockState)((BlockState)generator.getBlockSupplier().get().m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)((Direction)existingGenerator.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)))).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)((Boolean)existingGenerator.m_61143_((Property)BlockStateProperties.f_61443_)));
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            CompoundTag tag = generatorBlockEntity.m_187482_();
            generatorBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                if (handler instanceof ItemStackHandler) {
                    ItemStackHandler itemHandler = (ItemStackHandler)handler;
                    itemHandler.setStackInSlot(0, ItemStack.f_41583_);
                    itemHandler.setStackInSlot(1, ItemStack.f_41583_);
                }
            });
            level.m_46597_(pos, newGenerator);
            level.m_7702_(pos).m_142466_(tag);
        }
    }

    public static Pair<Float, Integer> calculateFoodGenerationRate(GeneratorObject generator, ItemStack stack) {
        FoodProperties foodProperties = stack.m_41720_().getFoodProperties(stack, null);
        if (foodProperties != null) {
            int value = foodProperties.m_38744_();
            float saturation = foodProperties.m_38745_();
            double totalRF = (float)value * saturation * 8000.0f;
            return Pair.of((Object)Float.valueOf((float)((double)value * generator.getOriginalGenerationRate())), (Object)((int)(totalRF / generator.getGenerationRate())));
        }
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)generator.getConsumptionRate()));
    }

    public static Pair<Float, Integer> calculateEnchantmentGenerationRate(GeneratorObject generator, ItemStack stack) {
        if (stack.m_41793_() || stack.m_41720_() instanceof EnchantedBookItem) {
            double totalRF = 0.0;
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
            for (Map.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                float level = ((Integer)entry.getValue()).intValue();
                float max = enchantment.m_6586_();
                float min = enchantment.m_6183_(((Integer)entry.getValue()).intValue());
                float weight = switch (enchantment.m_44699_()) {
                    default -> throw new IncompatibleClassChangeError();
                    case Enchantment.Rarity.COMMON -> 10.0f;
                    case Enchantment.Rarity.UNCOMMON -> 5.0f;
                    case Enchantment.Rarity.RARE -> 2.0f;
                    case Enchantment.Rarity.VERY_RARE -> 1.0f;
                };
                totalRF += Math.abs(Math.sqrt(Math.min((double)level + 1.0, (double)max) / (double)max) * Math.pow(max, 2.0) * (double)(level + 1.0f) * ((double)min / Math.sqrt(weight))) * 400.0;
            }
            return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)(totalRF / generator.getGenerationRate())));
        }
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)generator.getConsumptionRate()));
    }

    public static Pair<Float, Integer> calculatePotionGenerationRate(GeneratorObject generator, ItemStack stack) {
        int steps = GeneratorUtil.getBrewingSteps(PotionUtil.getUniquePotionName(stack), new HashSet<String>());
        double totalRF = 100.0 * Math.pow(4.0, steps);
        return Pair.of((Object)Float.valueOf((float)generator.getGenerationRate()), (Object)((int)(totalRF / generator.getGenerationRate())));
    }

    private static int getBrewingSteps(String potionOutputUid, Set<String> previousSteps) {
        SetMultiMap<String, String> potionMap = PotionUtil.getPotionMap();
        Integer cachedBrewingSteps = PotionUtil.brewingStepCache.get(potionOutputUid);
        if (cachedBrewingSteps != null) {
            return cachedBrewingSteps;
        }
        if (!previousSteps.add(potionOutputUid)) {
            return Integer.MAX_VALUE;
        }
        Collection prevPotions = potionMap.get((Object)potionOutputUid);
        int minPrevSteps = prevPotions.stream().mapToInt(prevPotion -> GeneratorUtil.getBrewingSteps(prevPotion, previousSteps)).min().orElse(Integer.MAX_VALUE);
        int brewingSteps = minPrevSteps == Integer.MAX_VALUE ? Integer.MAX_VALUE : minPrevSteps + 1;
        PotionUtil.brewingStepCache.put(potionOutputUid, brewingSteps);
        return brewingSteps;
    }

    public static enum FuelType implements StringRepresentable
    {
        SOLID("SOLID"),
        FLUID("FLUID"),
        FOOD("FOOD"),
        ENCHANTMENT("ENCHANTMENT"),
        POTION("POTION");

        private final String key;
        public static StringRepresentable.EnumCodec<FuelType> CODEC;

        private FuelType(String key) {
            this.key = key;
        }

        public String m_7912_() {
            return this.key;
        }

        static {
            CODEC = StringRepresentable.m_216439_(FuelType::values);
        }
    }
}

