/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.ShadowRenderHelper;
import com.simibubi.create.foundation.utility.Pair;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidStack;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.DisenchanterBlockEntity;
import plus.dragons.createenchantmentindustry.content.contraptions.enchanting.disenchanter.Disenchanting;

public class DisenchanterRenderer
extends SmartBlockEntityRenderer<DisenchanterBlockEntity> {
    public DisenchanterRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(DisenchanterBlockEntity be, float partialTicks, PoseStack ps, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)be, partialTicks, ps, buffer, light, overlay);
        this.renderItem(be, partialTicks, ps, buffer, light, overlay);
        this.renderFluid(be, partialTicks, ps, buffer, light);
    }

    protected void renderItem(DisenchanterBlockEntity be, float partialTicks, PoseStack ps, MultiBufferSource buffer, int light, int overlay) {
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        TransformStack ts = TransformStack.cast((PoseStack)ps);
        Direction insertedFrom = transported.insertedFrom;
        boolean horizontal = insertedFrom.m_122434_().m_122479_();
        ps.m_85836_();
        ps.m_252880_(0.5f, 0.8125f, 0.5f);
        ts.nudge(0);
        float offset = horizontal ? Mth.m_14179_((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition) : 0.5f;
        float sideOffset = horizontal ? Mth.m_14179_((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset) : 0.5f;
        Vec3 offsetVec = Vec3.m_82528_((Vec3i)insertedFrom.m_122424_().m_122436_()).m_82490_((double)(0.5f - offset));
        ps.m_85837_(offsetVec.f_82479_, 0.0, offsetVec.f_82481_);
        if (horizontal) {
            boolean alongX = insertedFrom.m_122427_().m_122434_() == Direction.Axis.X;
            ps.m_252880_(alongX ? sideOffset : 0.0f, 0.005f, alongX ? 0.0f : -sideOffset);
        } else {
            ps.m_252880_(0.0f, 0.005f, 0.0f);
        }
        ShadowRenderHelper.renderShadow((PoseStack)ps, (MultiBufferSource)buffer, (float)0.75f, (float)0.2f);
        ItemStack itemStack = transported.stack;
        Random r = new Random(0L);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        int count = Mth.m_14173_((int)itemStack.m_41613_()) / 2;
        boolean blockItem = itemRenderer.m_174264_(itemStack, null, null, 0).m_7539_();
        if (blockItem) {
            ps.m_252880_(0.0f, 0.125f, 0.0f);
        } else {
            ps.m_252880_(0.0f, 0.015625f, 0.0f);
        }
        int positive = insertedFrom.m_122421_().m_122540_();
        float verticalAngle = (float)positive * offset * 360.0f + 180.0f;
        if (insertedFrom.m_122434_() != Direction.Axis.X) {
            ts.rotateX((double)verticalAngle);
        }
        if (insertedFrom.m_122434_() != Direction.Axis.Z) {
            ts.rotateZ((double)(-verticalAngle));
        }
        int processingTicks = be.processingTicks;
        float processingProgress = switch (processingTicks) {
            case 0, 10 -> 0.0f;
            default -> Mth.m_14036_((float)(((float)processingTicks - partialTicks) / 10.0f), (float)0.0f, (float)1.0f);
        };
        ts.rotateY((double)(processingProgress * 360.0f));
        for (int i = 0; i <= count; ++i) {
            ps.m_85836_();
            if (blockItem) {
                ps.m_252880_(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            ps.m_85841_(0.5f, 0.5f, 0.5f);
            if (!blockItem) {
                ts.rotateX(90.0);
            }
            itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, light, overlay, ps, buffer, be.m_58904_(), 0);
            ps.m_85849_();
            if (!blockItem) {
                ts.rotateY(10.0);
            }
            ps.m_85837_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
        }
        ps.m_85849_();
    }

    protected void renderFluid(DisenchanterBlockEntity be, float partialTicks, PoseStack ps, MultiBufferSource buffer, int light) {
        SmartFluidTankBehaviour tank = be.internalTank;
        if (tank == null) {
            return;
        }
        SmartFluidTankBehaviour.TankSegment primaryTank = tank.getPrimaryTank();
        FluidStack tankFluidStack = primaryTank.getRenderedFluid();
        float level = primaryTank.getFluidLevel().getValue(partialTicks);
        if (!tankFluidStack.isEmpty() && level != 0.0f) {
            float yMin = 0.3125f;
            float min = 0.125f;
            float max = min + 0.75f;
            float yOffset = 0.4375f * level;
            ps.m_85836_();
            ps.m_252880_(0.0f, yOffset, 0.0f);
            FluidRenderer.renderFluidBox((FluidStack)tankFluidStack, (float)min, (float)(yMin - yOffset), (float)min, (float)max, (float)yMin, (float)max, (MultiBufferSource)buffer, (PoseStack)ps, (int)light, (boolean)false);
            ps.m_85849_();
        }
        if (be.processingTicks == 0) {
            return;
        }
        TransportedItemStack transported = be.heldItem;
        if (transported == null) {
            return;
        }
        Direction insertedFrom = transported.insertedFrom;
        boolean horizontal = insertedFrom.m_122434_().m_122479_();
        Pair<FluidStack, ItemStack> result = Disenchanting.disenchantResult(transported.stack, be.m_58904_());
        if (result == null) {
            return;
        }
        FluidStack xp = (FluidStack)result.getFirst();
        if (xp.isEmpty()) {
            return;
        }
        int processingTicks = be.processingTicks;
        float processingProgress = processingTicks == 0 ? 0.0f : Mth.m_14036_((float)(1.0f - ((float)processingTicks - partialTicks - 5.0f) / 10.0f), (float)0.0f, (float)1.0f);
        float radius = (float)(Math.pow(2.0f * processingProgress - 1.0f, 2.0) - 1.0);
        Vec3 itemPosition = new Vec3(0.5, 0.0, 0.5);
        float offset = horizontal ? Mth.m_14179_((float)partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition) : 0.5f;
        float sideOffset = horizontal ? Mth.m_14179_((float)partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset) : 0.5f;
        itemPosition = itemPosition.m_82549_(Vec3.m_82528_((Vec3i)insertedFrom.m_122424_().m_122436_()).m_82490_((double)(0.5f - offset)));
        if (horizontal) {
            boolean alongX = insertedFrom.m_122427_().m_122434_() == Direction.Axis.X;
            itemPosition.m_82520_(alongX ? (double)sideOffset : 0.0, 0.005, alongX ? 0.0 : (double)(-sideOffset));
        } else {
            itemPosition.m_82520_(0.0, 0.005, 0.0);
        }
        AABB bb = new AABB(itemPosition.m_82520_(0.0, 0.8125, 0.0), itemPosition.m_82520_(0.0, 0.25, 0.0)).m_82400_((double)(radius / 32.0f));
        FluidRenderer.renderFluidBox((FluidStack)xp, (float)((float)bb.f_82288_), (float)((float)bb.f_82289_), (float)((float)bb.f_82290_), (float)((float)bb.f_82291_), (float)((float)bb.f_82292_), (float)((float)bb.f_82293_), (MultiBufferSource)buffer, (PoseStack)ps, (int)light, (boolean)true);
    }
}

