/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class NBTHelper {
    private static final String SLOTS_TAG = "Slots";
    private static final String STACK_TAG = "Stack";
    private static final String COUNT_TAG = "Count";

    private NBTHelper() {
    }

    public static short getShort(String s, ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        return tagCompound.m_128448_(s);
    }

    public static void putShort(String s, ItemStack stack, short i) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        tagCompound.m_128376_(s, i);
        stack.m_41751_(tagCompound);
    }

    public static int getInt(String s, ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        return tagCompound.m_128451_(s);
    }

    public static void putInt(String s, ItemStack stack, int i) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        tagCompound.m_128405_(s, i);
        stack.m_41751_(tagCompound);
    }

    public static long getLong(String s, ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        return tagCompound.m_128454_(s);
    }

    public static void putLong(String s, ItemStack stack, long i) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        tagCompound.m_128356_(s, i);
        stack.m_41751_(tagCompound);
    }

    public static boolean getBoolean(String s, ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        return tagCompound.m_128471_(s);
    }

    public static void putBoolean(String s, ItemStack stack, boolean b) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        tagCompound.m_128379_(s, b);
        stack.m_41751_(tagCompound);
    }

    public static String getString(String s, ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        return tagCompound.m_128461_(s);
    }

    public static void putString(String s, ItemStack stack, String s1) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        tagCompound.m_128359_(s, s1);
        stack.m_41751_(tagCompound);
    }

    public static CompoundTag getTag(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return new CompoundTag();
        }
        return stack.m_41783_();
    }

    public static void putTagCompound(String s, ItemStack stack, CompoundTag tc) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        tagCompound.m_128365_(s, (Tag)tc);
        stack.m_41751_(tagCompound);
    }

    public static CompoundTag getTagCompound(String s, ItemStack stack) {
        CompoundTag tagCompound = NBTHelper.getTag(stack);
        return tagCompound.m_128469_(s);
    }

    public static void remove(@Nullable CompoundTag nbt, String tagName) {
        if (nbt != null) {
            nbt.m_128473_(tagName);
        }
    }

    public static void removeContainedStacks(ItemStack container) {
        NBTHelper.remove(container.m_41783_(), SLOTS_TAG);
    }

    public static void updateContainedStack(ItemStack container, short slot, ItemStack stackToSave, int count) {
        NBTHelper.updateContainedStack(container, slot, stackToSave, count, false);
    }

    public static void updateContainedStack(ItemStack container, short slot, ItemStack stackToSave, int count, boolean updateCountOnly) {
        CompoundTag slotTag;
        CompoundTag tag = NBTHelper.getTag(container);
        ListTag slots = tag.m_128437_(SLOTS_TAG, 10);
        while (slot > slots.size()) {
            slots.add((Object)NBTHelper.getEmptyStackNBT());
        }
        if (slot == slots.size()) {
            if (updateCountOnly) {
                return;
            }
            slotTag = new CompoundTag();
            slots.add((Object)slotTag);
        } else {
            slotTag = (CompoundTag)slots.get((int)slot);
        }
        if (!updateCountOnly) {
            slotTag.m_128365_(STACK_TAG, (Tag)stackToSave.m_41739_(new CompoundTag()));
        }
        slotTag.m_128405_(COUNT_TAG, count);
        slots.set((int)slot, (Tag)slotTag);
        tag.m_128365_(SLOTS_TAG, (Tag)slots);
        container.m_41751_(tag);
    }

    public static int getContainedStackCount(ItemStack container, int slot) {
        CompoundTag tag = NBTHelper.getTag(container);
        ListTag slots = tag.m_128437_(SLOTS_TAG, 10);
        if (slot < slots.size()) {
            CompoundTag slotTag = (CompoundTag)slots.get(slot);
            return slotTag.m_128451_(COUNT_TAG);
        }
        return 0;
    }

    public static int getCountContainedStacks(ItemStack container) {
        CompoundTag tag = NBTHelper.getTag(container);
        ListTag slots = tag.m_128437_(SLOTS_TAG, 10);
        return slots.size();
    }

    public static ItemStack getContainedStack(ItemStack container, int slot) {
        CompoundTag tag = NBTHelper.getTag(container);
        ListTag slots = tag.m_128437_(SLOTS_TAG, 10);
        if (slot < slots.size()) {
            CompoundTag slotTag = (CompoundTag)slots.get(slot);
            ItemStack ret = ItemStack.m_41712_((CompoundTag)slotTag.m_128469_(STACK_TAG));
            ret.m_41764_(slotTag.m_128451_(COUNT_TAG));
            return ret;
        }
        return ItemStack.f_41583_;
    }

    private static Tag getEmptyStackNBT() {
        CompoundTag slotTag = new CompoundTag();
        slotTag.m_128365_(STACK_TAG, (Tag)ItemStack.f_41583_.m_41739_(new CompoundTag()));
        slotTag.m_128405_(COUNT_TAG, 0);
        return slotTag;
    }

    public static <T extends Enum<T>> Optional<T> getEnumConstant(ItemStack stack, String key, Function<String, T> deserialize) {
        return NBTHelper.getTagValue(stack, key, (CompoundTag t, String k) -> (Enum)deserialize.apply(t.m_128461_(k)));
    }

    private static <T> Optional<T> getTagValue(ItemStack stack, String key, BiFunction<CompoundTag, String, T> getValue) {
        return NBTHelper.getTagValue(stack, "", key, getValue);
    }

    public static <T> Optional<T> getTagValue(ItemStack stack, String parentKey, String key, BiFunction<CompoundTag, String, T> getValue) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return Optional.empty();
        }
        if (!parentKey.isEmpty()) {
            Tag parentTag = tag.m_128423_(parentKey);
            if (!(parentTag instanceof CompoundTag)) {
                return Optional.empty();
            }
            tag = (CompoundTag)parentTag;
        }
        return NBTHelper.getTagValue(tag, key, getValue);
    }

    private static <T> Optional<T> getTagValue(CompoundTag tag, String key, BiFunction<CompoundTag, String, T> getValue) {
        if (!tag.m_128441_(key)) {
            return Optional.empty();
        }
        return Optional.of(getValue.apply(tag, key));
    }

    public static Optional<Integer> getInt(ItemStack stack, String key) {
        return NBTHelper.getTagValue(stack, key, CompoundTag::m_128451_);
    }
}

