/*
 * Decompiled with CFR 0.152.
 */
package reliquary.pedestal.wrappers;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.FakePlayer;
import reliquary.api.IPedestal;
import reliquary.api.IPedestalActionItemWrapper;
import reliquary.blocks.FertileLilyPadBlock;
import reliquary.init.ModItems;
import reliquary.items.HarvestRodItem;
import reliquary.reference.Settings;
import reliquary.util.ItemHelper;

public class PedestalHarvestRodWrapper
implements IPedestalActionItemWrapper {
    private static final int NO_JOB_COOL_DOWN_CYCLES = 10;
    private static final HarvestRodItem harvestRod = (HarvestRodItem)ModItems.HARVEST_ROD.get();
    private int hoeCoolDown = 0;
    private int plantCoolDown = 0;
    private int boneMealCoolDown = 0;
    private int breakCoolDown = 0;
    private final Queue<BlockPos> queueToHoe = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToPlant = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToBoneMeal = new ArrayDeque<BlockPos>();
    private final Queue<BlockPos> queueToBreak = new ArrayDeque<BlockPos>();

    @Override
    public void update(ItemStack stack, Level level, IPedestal pedestal) {
        BlockPos pos = pedestal.getBlockPosition();
        int cooldown = (Integer)Settings.COMMON.items.harvestRod.pedestalCooldown.get();
        pedestal.getFakePlayer().ifPresent(fakePlayer -> {
            int range = (Integer)Settings.COMMON.items.harvestRod.pedestalRange.get();
            this.hoeLand(level, (Player)fakePlayer, pos, range);
            this.plantSeeds(level, (Player)fakePlayer, pos, stack, range);
            this.boneMealCrops(level, (FakePlayer)fakePlayer, pos, stack, range);
            this.breakCrops(level, (Player)fakePlayer, pos, stack, range);
        });
        pedestal.setActionCoolDown(cooldown);
    }

    @Override
    public void onRemoved(ItemStack stack, Level level, IPedestal pedestal) {
        if (!level.f_46443_) {
            harvestRod.updateContainedStacks(stack);
        }
    }

    @Override
    public void stop(ItemStack stack, Level level, IPedestal pedestal) {
    }

    private void breakCrops(Level world, Player player, BlockPos pos, ItemStack stack, int range) {
        if (this.breakCoolDown > 0) {
            --this.breakCoolDown;
        } else if (!this.breakNext(world, player, pos, stack, range)) {
            this.breakCoolDown = 10;
        }
    }

    private boolean breakNext(Level world, Player player, BlockPos pos, ItemStack stack, int range) {
        return this.getNextBlockToBreak(world, pos, range).map(nextBlockToBreak -> {
            this.doHarvestBlockBreak(world, player, stack, (BlockPos)nextBlockToBreak);
            return true;
        }).orElse(false);
    }

    private void doHarvestBlockBreak(Level world, Player player, ItemStack stack, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        List drops = Block.m_49874_((BlockState)blockState, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null, (Entity)player, (ItemStack)stack);
        for (ItemStack drop : drops) {
            float f = 0.7f;
            double d = (double)(world.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.f_46441_.m_188501_() * f) + (double)(1.0f - f) * 0.5;
            ItemEntity entityitem = new ItemEntity(world, (double)pos.m_123341_() + d, (double)pos.m_123342_() + d1, (double)pos.m_123343_() + d2, drop);
            entityitem.m_32010_(10);
            world.m_7967_((Entity)entityitem);
        }
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    private void boneMealCrops(Level level, FakePlayer fakePlayer, BlockPos pos, ItemStack stack, int range) {
        if (this.boneMealCoolDown > 0) {
            --this.boneMealCoolDown;
        } else {
            if (harvestRod.getBoneMealCount(stack) >= harvestRod.getBonemealCost() && this.boneMealNext(level, fakePlayer, pos, stack, range)) {
                return;
            }
            this.boneMealCoolDown = 10;
        }
    }

    private boolean boneMealNext(Level world, FakePlayer fakePlayer, BlockPos pos, ItemStack stack, int range) {
        return this.getNextBlockToBoneMeal(world, pos, range).map(blockToBoneMeal -> {
            this.boneMealBlock(stack, fakePlayer, world, (BlockPos)blockToBoneMeal);
            return true;
        }).orElse(false);
    }

    private void boneMealBlock(ItemStack stack, FakePlayer fakePlayer, Level world, BlockPos pos) {
        ItemStack fakeItemStack = new ItemStack((ItemLike)Items.f_42499_);
        boolean boneMealUsed = false;
        for (int repeatedUses = 0; repeatedUses <= harvestRod.getLuckRolls(); ++repeatedUses) {
            if (repeatedUses != 0 && world.f_46441_.m_188503_(100) > harvestRod.getLuckPercent() || !BoneMealItem.applyBonemeal((ItemStack)fakeItemStack, (Level)world, (BlockPos)pos, (Player)fakePlayer)) continue;
            boneMealUsed = true;
        }
        if (boneMealUsed) {
            world.m_46796_(2005, pos, 0);
            harvestRod.setBoneMealCount(stack, harvestRod.getBoneMealCount(stack) - harvestRod.getBonemealCost());
        }
    }

    private void plantSeeds(Level world, Player player, BlockPos pos, ItemStack stack, int range) {
        if (this.plantCoolDown > 0) {
            --this.plantCoolDown;
        } else {
            byte plantableSlot = 1;
            if (harvestRod.getCountPlantable(stack) > 0) {
                harvestRod.clearPlantableIfNoLongerValid(stack, plantableSlot);
                int quantity = harvestRod.getPlantableQuantity(stack, plantableSlot);
                if (quantity > 0 && this.plantNext(world, player, pos, stack, range, plantableSlot)) {
                    return;
                }
            }
            this.plantCoolDown = 10;
        }
    }

    private boolean plantNext(Level world, Player player, BlockPos pos, ItemStack stack, int range, byte plantableSlot) {
        return this.getNextBlockToPlantOn(world, pos, range, (IPlantable)((BlockItem)harvestRod.getPlantableInSlot(stack, plantableSlot).m_41720_()).m_40614_()).map(blockToPlantOn -> {
            this.plantItem(player, (BlockPos)blockToPlantOn, stack, plantableSlot);
            return true;
        }).orElse(false);
    }

    private void plantItem(Player player, BlockPos pos, ItemStack stack, byte idx) {
        ItemStack fakePlantableStack = harvestRod.getPlantableInSlot(stack, idx).m_41777_();
        fakePlantableStack.m_41764_(1);
        player.m_21008_(InteractionHand.MAIN_HAND, fakePlantableStack);
        if (fakePlantableStack.m_41661_(ItemHelper.getItemUseContext(pos, player)) == InteractionResult.SUCCESS) {
            harvestRod.setPlantableQuantityAndGetPlantableStack(stack, idx, harvestRod.getPlantableQuantity(stack, idx) - 1);
        }
    }

    private void hoeLand(Level world, Player player, BlockPos pos, int range) {
        if (this.hoeCoolDown > 0) {
            --this.hoeCoolDown;
        } else if (!this.hoeNext(world, player, pos, range)) {
            this.hoeCoolDown = 10;
        }
    }

    private boolean hoeNext(Level world, Player player, BlockPos pos, int range) {
        return this.getNextBlockToHoe(world, pos, range).map(blockToHoe -> {
            ItemStack fakeHoe = new ItemStack((ItemLike)Items.f_42424_);
            player.m_21008_(InteractionHand.MAIN_HAND, fakeHoe);
            Items.f_42424_.m_6225_(ItemHelper.getItemUseContext(blockToHoe, player));
            return true;
        }).orElse(false);
    }

    private Optional<BlockPos> getNextBlockToBreak(Level world, BlockPos pos, int range) {
        if (this.queueToBreak.isEmpty()) {
            this.fillQueueToBreak(world, pos, range);
        }
        return Optional.ofNullable(this.queueToBreak.poll());
    }

    private void fillQueueToBreak(Level world, BlockPos pos, int range) {
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.m_7949_();
            BlockState state = world.m_8055_(currentPos);
            Block block = state.m_60734_();
            if (block instanceof IPlantable || block == Blocks.f_50186_ || block == Blocks.f_50133_) {
                CropBlock cropBlock;
                if (block instanceof FertileLilyPadBlock || block == Blocks.f_50189_ || block == Blocks.f_50190_ || block instanceof CropBlock && (cropBlock = (CropBlock)block).m_7370_((LevelReader)world, currentPos, state, false) || block instanceof NetherWartBlock && (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) < 3 || block instanceof SweetBerryBushBlock && (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) < 3) {
                    return;
                }
                this.queueToBreak.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToHoe(Level world, BlockPos pos, int range) {
        if (this.queueToHoe.isEmpty()) {
            this.fillQueueToHoe(world, pos, range);
        }
        return Optional.ofNullable(this.queueToHoe.poll());
    }

    private void fillQueueToHoe(Level world, BlockPos pos, int range) {
        this.queueToHoe.clear();
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.m_7949_();
            BlockState blockState = world.m_8055_(currentPos);
            Block block = blockState.m_60734_();
            if (world.m_46859_(currentPos.m_7494_()) && (block == Blocks.f_50440_ || block == Blocks.f_152481_ || block == Blocks.f_50493_ || block == Blocks.f_50546_)) {
                this.queueToHoe.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToPlantOn(Level world, BlockPos pos, int range, IPlantable plantable) {
        if (this.queueToPlant.isEmpty()) {
            this.fillQueueToPlant(world, pos, range, plantable);
        }
        return Optional.ofNullable(this.queueToPlant.poll());
    }

    private void fillQueueToPlant(Level world, BlockPos pos, int range, IPlantable plantable) {
        this.queueToPlant.clear();
        boolean checkerboard = false;
        boolean bothOddOrEven = false;
        if (plantable == Items.f_42577_ || plantable == Items.f_42578_) {
            checkerboard = true;
            boolean xEven = pos.m_123341_() % 2 == 0;
            boolean zEven = pos.m_123343_() % 2 == 0;
            bothOddOrEven = xEven == zEven;
        }
        boolean finalCheckerboard = checkerboard;
        boolean finalBothOddOrEven = bothOddOrEven;
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(p -> {
            BlockPos currentPos = p.m_7949_();
            BlockState blockState = world.m_8055_(currentPos);
            if ((!finalCheckerboard || finalBothOddOrEven == (currentPos.m_123341_() % 2 == 0 == (currentPos.m_123343_() % 2 == 0))) && blockState.m_60734_().canSustainPlant(blockState, (BlockGetter)world, pos, Direction.UP, plantable) && world.m_46859_(currentPos.m_7494_())) {
                this.queueToPlant.add(currentPos);
            }
        });
    }

    private Optional<BlockPos> getNextBlockToBoneMeal(Level world, BlockPos pos, int range) {
        if (this.queueToBoneMeal.isEmpty()) {
            this.fillQueueToBoneMeal(world, pos, range);
        }
        return Optional.ofNullable(this.queueToBoneMeal.poll());
    }

    private void fillQueueToBoneMeal(Level world, BlockPos pos, int range) {
        this.queueToBoneMeal.clear();
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-range, -range, -range), (BlockPos)pos.m_7918_(range, range, range)).forEach(p -> {
            BonemealableBlock bonemealableBlock;
            Block patt11455$temp;
            BlockPos currentPos = p.m_7949_();
            BlockState blockState = world.m_8055_(currentPos);
            if (blockState.m_60734_() != Blocks.f_50440_ && (patt11455$temp = blockState.m_60734_()) instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)patt11455$temp).m_7370_((LevelReader)world, currentPos, blockState, world.f_46443_)) {
                this.queueToBoneMeal.add(currentPos);
            }
        });
    }
}

