/*
 * Decompiled with CFR 0.152.
 */
package reliquary.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import reliquary.entities.ConcussiveExplosion;

public class PacketFXConcussiveExplosion {
    private final float size;
    private final Vec3 pos;

    public PacketFXConcussiveExplosion(float size, Vec3 pos) {
        this.size = size;
        this.pos = pos;
    }

    static void encode(PacketFXConcussiveExplosion msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeFloat(msg.size);
        packetBuffer.writeDouble(msg.pos.m_7096_());
        packetBuffer.writeDouble(msg.pos.m_7098_());
        packetBuffer.writeDouble(msg.pos.m_7094_());
    }

    static PacketFXConcussiveExplosion decode(FriendlyByteBuf packetBuffer) {
        return new PacketFXConcussiveExplosion(packetBuffer.readFloat(), new Vec3(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble()));
    }

    static void onMessage(PacketFXConcussiveExplosion msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> PacketFXConcussiveExplosion.handleMessage(msg));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleMessage(PacketFXConcussiveExplosion message) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        ConcussiveExplosion explosion = new ConcussiveExplosion((Level)level, null, null, message.pos, message.size, false);
        explosion.m_46075_(false);
    }
}

