/*
 * Decompiled with CFR 0.152.
 */
package reliquary.items;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reliquary.items.ToggleableItem;
import reliquary.reference.Settings;
import reliquary.util.InventoryHelper;
import reliquary.util.NBTHelper;
import reliquary.util.RegistryHelper;
import reliquary.util.TooltipBuilder;

public class MidasTouchstoneItem
extends ToggleableItem {
    private static final Map<Class<? extends Item>, IRepairableItem> REPAIRABLE_ITEMS = new ImmutableMap.Builder().put(TieredItem.class, item -> {
        Tier tier = ((TieredItem)item).m_43314_();
        return tier.equals(Tiers.GOLD) || tier.equals(Tiers.NETHERITE);
    }).put(ArmorItem.class, item -> {
        ArmorMaterial material = ((ArmorItem)item).m_40401_();
        return material.equals(ArmorMaterials.GOLD) || material.equals(ArmorMaterials.NETHERITE);
    }).build();
    private static final String GLOWSTONE_TAG = "glowstone";

    public MidasTouchstoneItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void addMoreInformation(ItemStack touchstone, @Nullable Level world, TooltipBuilder tooltipBuilder) {
        tooltipBuilder.charge(this, ".tooltip2", NBTHelper.getInt(GLOWSTONE_TAG, touchstone));
        if (this.isEnabled(touchstone)) {
            tooltipBuilder.absorbActive(Items.f_42525_.m_7626_(new ItemStack((ItemLike)Items.f_42525_)).getString());
        } else {
            tooltipBuilder.absorb();
        }
    }

    @Override
    protected boolean hasMoreInformation(ItemStack stack) {
        return true;
    }

    public Rarity m_41460_(ItemStack stack) {
        return Rarity.EPIC;
    }

    public void m_6883_(ItemStack stack, Level world, Entity e, int i, boolean f) {
        if (world.f_46443_ || world.m_46467_() % 10L != 0L || !(e instanceof Player)) {
            return;
        }
        Player player = (Player)e;
        if (this.isEnabled(stack)) {
            int glowstoneCharge = NBTHelper.getInt(GLOWSTONE_TAG, stack);
            this.consumeAndCharge(player, this.getGlowstoneLimit() - glowstoneCharge, this.getGlowStoneWorth(), Items.f_42525_, 16, (int chargeToAdd) -> NBTHelper.putInt(GLOWSTONE_TAG, stack, glowstoneCharge + chargeToAdd));
        }
        this.doRepairAndDamageTouchstone(stack, player);
    }

    private void doRepairAndDamageTouchstone(ItemStack touchstone, Player player) {
        InventoryHelper.getItemHandlerFrom(player, null).ifPresent(itemHandler -> {
            for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                ItemStack stack = itemHandler.getStackInSlot(slot);
                Item item = stack.m_41720_();
                if (stack.m_41773_() <= 0 || !stack.m_41720_().m_41465_()) continue;
                this.tryRepairingItem(touchstone, player, Settings.COMMON.items.midasTouchstone.getGoldItems(), stack, item);
            }
        });
    }

    private void tryRepairingItem(ItemStack touchstone, Player player, List<String> goldItems, ItemStack stack, Item item) {
        Optional<IRepairableItem> repairableItem = this.getRepairableItem(item.getClass());
        if (repairableItem.isPresent() && repairableItem.get().materialMatches(item) || goldItems.contains(RegistryHelper.getItemRegistryName(item))) {
            this.repairItem(stack, touchstone, player);
        }
    }

    private void repairItem(ItemStack stack, ItemStack touchstone, Player player) {
        if (this.reduceTouchStoneCharge(touchstone, player)) {
            int damage = stack.m_41773_();
            stack.m_41721_(damage - Math.min(damage, 10));
        }
    }

    private boolean reduceTouchStoneCharge(ItemStack stack, Player player) {
        if (NBTHelper.getInt(GLOWSTONE_TAG, stack) - this.getGlowStoneCost() >= 0 || player.m_7500_()) {
            if (!player.m_7500_()) {
                NBTHelper.putInt(GLOWSTONE_TAG, stack, NBTHelper.getInt(GLOWSTONE_TAG, stack) - this.getGlowStoneCost());
            }
            return true;
        }
        return false;
    }

    private int getGlowStoneCost() {
        return (Integer)Settings.COMMON.items.midasTouchstone.glowstoneCost.get();
    }

    private int getGlowStoneWorth() {
        return (Integer)Settings.COMMON.items.midasTouchstone.glowstoneWorth.get();
    }

    private int getGlowstoneLimit() {
        return (Integer)Settings.COMMON.items.midasTouchstone.glowstoneLimit.get();
    }

    private Optional<IRepairableItem> getRepairableItem(Class<? extends Item> item) {
        for (Map.Entry<Class<? extends Item>, IRepairableItem> repairableItem : REPAIRABLE_ITEMS.entrySet()) {
            if (!repairableItem.getKey().isAssignableFrom(item)) continue;
            return Optional.of(repairableItem.getValue());
        }
        return Optional.empty();
    }

    private static interface IRepairableItem {
        public boolean materialMatches(Item var1);
    }
}

