/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entities.ConcussiveExplosion;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class SandShotEntity
extends ShotEntityBase {
    public SandShotEntity(EntityType<SandShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public SandShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.SAND_SHOT.get(), world, player, hand);
    }

    @Override
    void doFiringEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnHitParticles(1);
        }
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        this.spawnHitParticles(8);
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.m_9236_().m_7106_((ParticleOptions)DustParticleOptions.f_123656_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (double)0.7f, (double)0.7f, (double)0.3f);
        }
    }

    @Override
    int getDamageOfShot(LivingEntity e) {
        if (e instanceof Creeper) {
            ConcussiveExplosion.customBusterExplosion((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f);
            this.getShooterPlayer().ifPresent(player -> e.m_6469_(this.m_269291_().m_269075_(player), 20.0f));
            return 0;
        }
        if (e instanceof Mob) {
            e.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 200, 1));
        }
        return (this.m_9236_().m_6106_().m_6533_() ? 4 : 8) + this.d6();
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.SAND;
    }
}

