/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import reliquary.entities.shot.ShotEntityBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class EnderShotEntity
extends ShotEntityBase {
    public EnderShotEntity(EntityType<EnderShotEntity> entityType, Level world) {
        super(entityType, world);
    }

    public EnderShotEntity(Level world, Player player, InteractionHand hand) {
        super((EntityType)ModEntities.ENDER_SHOT.get(), world, player, hand);
    }

    private void doPortalExplosion() {
        for (int particles = 0; particles < 3; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123760_, this.m_20186_() - 1.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        this.m_146870_();
    }

    @Override
    void doBurstEffect(Direction sideHit) {
    }

    @Override
    void doFiringEffects() {
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123770_, this.m_20185_() + this.smallGauss(0.1), this.m_20186_() + this.smallGauss(0.1), this.m_20189_() + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123744_);
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.ENTITY) {
            Entity entityHit = ((EntityHitResult)result).m_82443_();
            if (entityHit == this.m_19749_() || !(entityHit instanceof LivingEntity)) {
                return;
            }
            this.onImpact((LivingEntity)entityHit);
        }
    }

    @Override
    protected void onImpact(LivingEntity mop) {
        if (mop != this.m_19749_() || this.ticksInAir > 3) {
            this.doDamage(mop);
        }
        this.spawnHitParticles(8);
    }

    @Override
    protected void groundImpact(Direction sideHit) {
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123760_, this.m_20186_() - 1.0);
        }
        this.seekTarget();
        if (this.ticksInAir > 100) {
            this.doPortalExplosion();
        }
    }

    @Override
    void spawnHitParticles(int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.f_123771_);
        }
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 16 + this.d12();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.ENDER;
    }
}

