/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entities;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import reliquary.init.ModEntities;
import reliquary.init.ModItems;
import reliquary.util.potions.XRPotionHelper;

public class XRTippedArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(XRTippedArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private List<MobEffectInstance> effects = Lists.newArrayList();

    public XRTippedArrowEntity(EntityType<XRTippedArrowEntity> entityType, Level world) {
        super(entityType, world);
    }

    public XRTippedArrowEntity(Level world, double x, double y, double z) {
        super((EntityType)ModEntities.TIPPED_ARROW.get(), x, y, z, world);
    }

    public XRTippedArrowEntity(Level world, LivingEntity shooter) {
        super((EntityType)ModEntities.TIPPED_ARROW.get(), shooter, world);
    }

    public void setPotionEffect(ItemStack stack) {
        this.effects = XRPotionHelper.getPotionEffectsFromStack(stack);
        this.f_19804_.m_135381_(COLOR, (Object)PotionUtils.m_43564_(this.effects));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(COLOR, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.spawnPotionParticles(1);
                }
            } else {
                this.spawnPotionParticles(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.m_9236_().m_7605_((Entity)this, (byte)0);
            this.effects.clear();
            this.f_19804_.m_135381_(COLOR, (Object)0);
        }
    }

    private void spawnPotionParticles(int particleCount) {
        int i = this.getColor();
        if (i != 0 && particleCount > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i & 0xFF) / 255.0;
            for (int j = 0; j < particleCount; ++j) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), d0, d1, d2);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        XRPotionHelper.addPotionEffectsToCompoundTag(compound, this.effects);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.effects = XRPotionHelper.getPotionEffectsFromCompoundTag(compound);
        if (!this.effects.isEmpty()) {
            this.f_19804_.m_135381_(COLOR, (Object)PotionUtils.m_43564_(this.effects));
        }
    }

    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        Entity shooter = this.m_19749_();
        if (shooter != null) {
            XRPotionHelper.applyEffectsToEntity(this.effects, (Entity)this, shooter, living);
        }
    }

    protected ItemStack m_7941_() {
        if (this.effects.isEmpty()) {
            return new ItemStack((ItemLike)Items.f_42412_);
        }
        ItemStack itemstack = new ItemStack((ItemLike)ModItems.TIPPED_ARROW.get());
        XRPotionHelper.addPotionEffectsToStack(itemstack, this.effects);
        return itemstack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7822_(byte id) {
        if (id == 0) {
            int i = this.getColor();
            if (i > 0) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.m_188500_() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * (double)this.m_20205_(), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(id);
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

