/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.processors;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockRotProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFStructureProcessors;

public final class TargetedRotProcessor
extends BlockRotProcessor {
    public static final Codec<TargetedRotProcessor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockState.f_61039_.listOf().xmap(ImmutableSet::copyOf, ArrayList::new).fieldOf("blocks_to_rot").forGetter(p -> p.blocksToRot), (App)Codec.FLOAT.fieldOf("integrity").orElse((Object)Float.valueOf(1.0f)).forGetter(p -> Float.valueOf(p.f_74075_))).apply((Applicative)instance, TargetedRotProcessor::new));
    private final ImmutableSet<BlockState> blocksToRot;

    public TargetedRotProcessor(ImmutableSet<BlockState> blocksToRot, float integrity) {
        super(integrity);
        this.blocksToRot = blocksToRot;
    }

    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos origin, BlockPos centerBottom, StructureTemplate.StructureBlockInfo originalBlockInfo, StructureTemplate.StructureBlockInfo modifiedBlockInfo, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        if (!this.blocksToRot.contains((Object)modifiedBlockInfo.f_74676_())) {
            return modifiedBlockInfo;
        }
        return super.m_7382_(level, origin, centerBottom, originalBlockInfo, modifiedBlockInfo, settings);
    }

    protected StructureProcessorType<?> m_6953_() {
        return (StructureProcessorType)TFStructureProcessors.TARGETED_ROT.get();
    }
}

