/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.compat.Compat;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import top.theillusivec4.curios.api.CuriosApi;

@OnlyIn(value=Dist.CLIENT)
public class PlayerLayerTrinkets
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final Set<Item> alreadyRendered = new HashSet<Item>();

    public PlayerLayerTrinkets(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> p_117346_) {
        super(p_117346_);
    }

    public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!((Boolean)ModConfig.instance.renderItemsOnPlayer.get()).booleanValue()) {
            return;
        }
        if (player.m_21124_(MobEffects.f_19609_) != null) {
            return;
        }
        ItemStack main = player.m_21205_();
        ItemStack second = player.m_21206_();
        this.alreadyRendered.clear();
        matrixStackIn.m_85836_();
        this.render((Player)player, ITrinketItem.RenderType.BODY, main, second, matrixStackIn, bufferIn, packedLightIn);
        float yaw = player.f_20886_ + (player.f_20885_ - player.f_20886_) * partialTicks;
        float yawOffset = player.f_20884_ + (player.f_20883_ - player.f_20884_) * partialTicks;
        float pitch = player.f_19860_ + (player.m_146909_() - player.f_19860_) * partialTicks;
        matrixStackIn.m_252781_(Axis.f_252392_.m_252977_(yawOffset));
        matrixStackIn.m_252781_(Axis.f_252436_.m_252977_(yaw - 270.0f));
        matrixStackIn.m_252781_(Axis.f_252403_.m_252977_(pitch));
        this.render((Player)player, ITrinketItem.RenderType.HEAD, main, second, matrixStackIn, bufferIn, packedLightIn);
        matrixStackIn.m_85849_();
    }

    private void render(Player player, ITrinketItem.RenderType type, ItemStack main, ItemStack second, PoseStack matrices, MultiBufferSource buffer, int packedLight) {
        IItemHandler handler;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            this.renderStack(player.m_150109_().m_8020_(i), player, type, main, second, matrices, buffer, packedLight);
        }
        if (Compat.hasCompat("curios") && (handler = (IItemHandler)CuriosApi.getCuriosHelper().getEquippedCurios((LivingEntity)player).orElse(null)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                this.renderStack(handler.getStackInSlot(i), player, type, main, second, matrices, buffer, packedLight);
            }
        }
    }

    private void renderStack(ItemStack stack, Player player, ITrinketItem.RenderType type, ItemStack main, ItemStack second, PoseStack matrices, MultiBufferSource buffer, int packedLight) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ITrinketItem && !this.alreadyRendered.contains(item)) {
            matrices.m_85836_();
            if (type == ITrinketItem.RenderType.BODY && player.m_20089_() == Pose.CROUCHING) {
                matrices.m_252880_(0.0f, 0.2f, 0.0f);
                matrices.m_252781_(Axis.f_252529_.m_252977_(28.647888f));
            }
            ((ITrinketItem)item).render(stack, player, type, matrices, buffer, packedLight, stack == main || stack == second);
            matrices.m_85849_();
            this.alreadyRendered.add(item);
        }
    }
}

