/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.api.event;

import com.hollingsworth.arsnouveau.api.event.ITimedEvent;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class DelayedSpellEvent
implements ITimedEvent {
    public int duration;
    public final SpellResolver resolver;
    public final HitResult result;
    public final Level world;

    @Deprecated(forRemoval=true)
    public DelayedSpellEvent(int delay, Spell spell, HitResult result, Level world, @Nullable LivingEntity shooter, SpellContext resolver) {
        this(delay, result, world, new SpellResolver(resolver));
    }

    public DelayedSpellEvent(int delay, HitResult result, Level world, SpellResolver resolver) {
        this.duration = delay;
        this.result = result;
        this.world = world;
        this.resolver = resolver;
    }

    @Override
    public void tick(boolean serverSide) {
        --this.duration;
        if (this.duration <= 0 && serverSide) {
            this.resolveSpell();
        } else if (!serverSide && this.result != null) {
            BlockPos hitVec = this.result instanceof EntityHitResult ? ((EntityHitResult)this.result).m_82443_().m_20183_() : BlockPos.m_274446_((Position)this.result.m_82450_());
            ParticleUtil.spawnTouch((ClientLevel)this.world, hitVec, this.resolver.spellContext.getColors());
        }
    }

    public void resolveSpell() {
        EntityHitResult ehr;
        if (this.world == null) {
            return;
        }
        HitResult hitResult = this.result;
        if (hitResult instanceof EntityHitResult && (ehr = (EntityHitResult)hitResult).m_82443_().m_213877_()) {
            return;
        }
        this.resolver.resume(this.world);
    }

    @Override
    public boolean isExpired() {
        return this.duration <= 0 || this.world == null;
    }
}

