/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.slime.SlimyCapability;
import de.melanx.utilitix.content.slime.StickyChunk;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record StickyChunkUpdate(ChunkPos pos, StickyChunk data) {

    public static class Serializer
    implements PacketSerializer<StickyChunkUpdate> {
        public Class<StickyChunkUpdate> messageClass() {
            return StickyChunkUpdate.class;
        }

        public void encode(StickyChunkUpdate msg, FriendlyByteBuf buffer) {
            buffer.writeInt(msg.pos().f_45578_);
            buffer.writeInt(msg.pos().f_45579_);
            msg.data().write(buffer);
        }

        public StickyChunkUpdate decode(FriendlyByteBuf buffer) {
            ChunkPos pos = new ChunkPos(buffer.readInt(), buffer.readInt());
            StickyChunk chunk = new StickyChunk();
            chunk.read(buffer);
            return new StickyChunkUpdate(pos, chunk);
        }
    }

    public static class Handler
    implements PacketHandler<StickyChunkUpdate> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(StickyChunkUpdate msg, Supplier<NetworkEvent.Context> ctx) {
            StickyChunk glue;
            LevelChunk loaded;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && level.m_46805_(new BlockPos(msg.pos().m_45604_(), 0, msg.pos().m_45605_())) && (loaded = level.m_6325_(msg.pos().f_45578_, msg.pos().f_45579_)) != null && (glue = (StickyChunk)loaded.getCapability(SlimyCapability.STICKY_CHUNK).orElse(null)) != null) {
                glue.loadFrom(msg.data());
                return true;
            }
            UtilitiX.getInstance().logger.warn("Received invalid sticky chunk packet for unloaded chunk: (" + msg.pos().f_45578_ + "," + msg.pos().f_45579_ + ")");
            return true;
        }
    }
}

