/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.blockentity;

import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.blockentity.config.IComparable;
import com.refinedmods.refinedstorage.blockentity.config.IType;
import com.refinedmods.refinedstorage.blockentity.config.IWhitelistBlacklist;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationSpec;
import com.refinedmods.refinedstorage.util.LevelUtils;
import com.ultramega.cabletiers.CableTier;
import com.ultramega.cabletiers.ContentType;
import com.ultramega.cabletiers.blockentity.TieredBlockEntity;
import com.ultramega.cabletiers.node.diskmanipulator.TieredDiskManipulatorNetworkNode;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class TieredDiskManipulatorBlockEntity
extends TieredBlockEntity<TieredDiskManipulatorNetworkNode> {
    public static final BlockEntitySynchronizationParameter<Integer, TieredDiskManipulatorBlockEntity> COMPARE = IComparable.createParameter((ResourceLocation)new ResourceLocation("cabletiers", "tiered_disk_manipulator_compare"));
    public static final BlockEntitySynchronizationParameter<Integer, TieredDiskManipulatorBlockEntity> WHITELIST_BLACKLIST = IWhitelistBlacklist.createParameter((ResourceLocation)new ResourceLocation("cabletiers", "tiered_disk_manipulator_whitelist_blacklist"));
    public static final BlockEntitySynchronizationParameter<Integer, TieredDiskManipulatorBlockEntity> TYPE = IType.createParameter((ResourceLocation)new ResourceLocation("cabletiers", "tiered_disk_manipulator_type"));
    public static final BlockEntitySynchronizationParameter<Integer, TieredDiskManipulatorBlockEntity> IO_MODE = new BlockEntitySynchronizationParameter(new ResourceLocation("cabletiers", "tiered_disk_manipulator_mode"), EntityDataSerializers.f_135028_, (Object)0, t -> ((TieredDiskManipulatorNetworkNode)t.getNode()).getIoMode(), (t, v) -> {
        ((TieredDiskManipulatorNetworkNode)t.getNode()).setIoMode((int)v);
        ((TieredDiskManipulatorNetworkNode)t.getNode()).markDirty();
    });
    public static final ModelProperty<DiskState[]> DISK_STATE_PROPERTY = new ModelProperty();
    public static BlockEntitySynchronizationSpec SPEC = BlockEntitySynchronizationSpec.builder().addWatchedParameter(REDSTONE_MODE).addWatchedParameter(COMPARE).addWatchedParameter(WHITELIST_BLACKLIST).addWatchedParameter(TYPE).addWatchedParameter(IO_MODE).build();
    private static final String NBT_DISK_STATE = "DiskStates";
    private final LazyOptional<IItemHandler> diskCapability = LazyOptional.of(() -> ((TieredDiskManipulatorNetworkNode)this.getNode()).getDisks());
    private final DiskState[] diskState = new DiskState[6 * this.checkTierMultiplier()];

    public TieredDiskManipulatorBlockEntity(CableTier tier, BlockPos pos, BlockState state) {
        super(ContentType.DISK_MANIPULATOR, tier, pos, state, SPEC);
        Arrays.fill(this.diskState, DiskState.NONE);
    }

    private int checkTierMultiplier() {
        return switch (this.getTier()) {
            default -> throw new IncompatibleClassChangeError();
            case CableTier.ELITE -> 2;
            case CableTier.ULTRA -> 3;
            case CableTier.MEGA -> 4;
        };
    }

    public CompoundTag writeUpdate(CompoundTag tag) {
        super.writeUpdate(tag);
        ListTag list = new ListTag();
        for (DiskState state : ((TieredDiskManipulatorNetworkNode)this.getNode()).getDiskState()) {
            list.add((Object)IntTag.m_128679_((int)state.ordinal()));
        }
        tag.m_128365_(NBT_DISK_STATE, (Tag)list);
        return tag;
    }

    public void readUpdate(CompoundTag tag) {
        super.readUpdate(tag);
        ListTag list = tag.m_128437_(NBT_DISK_STATE, 3);
        for (int i = 0; i < list.size(); ++i) {
            this.diskState[i] = DiskState.values()[list.m_128763_(i)];
        }
        this.requestModelDataUpdate();
        LevelUtils.updateBlock((Level)this.f_58857_, (BlockPos)this.f_58858_);
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(DISK_STATE_PROPERTY, (Object)this.diskState).build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction direction) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.diskCapability.cast();
        }
        return super.getCapability(cap, direction);
    }
}

