/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.crafting.IPatternDetails;
import appeng.api.implementations.blockentities.IChestOrDrive;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.storage.cells.StorageCell;
import gripe._90.megacells.item.cell.BulkCellInventory;
import gripe._90.megacells.item.part.DecompressionModulePart;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public class DecompressionService
implements IGridService,
IGridServiceProvider {
    private final List<IChestOrDrive> cellHosts = new ObjectArrayList();
    private final List<IPatternDetails> patterns = new ObjectArrayList();
    private final List<DecompressionModulePart> modules = new ObjectArrayList();

    public void addNode(IGridNode node, CompoundTag savedData) {
        Object object = node.getOwner();
        if (object instanceof IChestOrDrive) {
            IChestOrDrive cellHost = (IChestOrDrive)object;
            this.cellHosts.add(cellHost);
        }
        if ((object = node.getOwner()) instanceof DecompressionModulePart) {
            DecompressionModulePart module = (DecompressionModulePart)((Object)object);
            this.modules.add(module);
        }
    }

    public void removeNode(IGridNode node) {
        Object object = node.getOwner();
        if (object instanceof IChestOrDrive) {
            IChestOrDrive cellHost = (IChestOrDrive)object;
            this.cellHosts.remove(cellHost);
        }
        if ((object = node.getOwner()) instanceof DecompressionModulePart) {
            DecompressionModulePart module = (DecompressionModulePart)((Object)object);
            this.modules.remove((Object)module);
        }
    }

    public void onServerStartTick() {
        this.patterns.clear();
        for (IChestOrDrive cellHost : this.cellHosts) {
            for (int i = 0; i < cellHost.getCellCount(); ++i) {
                StorageCell cell = cellHost.getOriginalCellInventory(i);
                if (!(cell instanceof BulkCellInventory)) continue;
                BulkCellInventory bulkCell = (BulkCellInventory)cell;
                this.patterns.addAll(bulkCell.getDecompressionPatterns());
            }
        }
        for (DecompressionModulePart module : this.modules) {
            ICraftingProvider.requestUpdate((IManagedGridNode)module.getMainNode());
        }
    }

    public List<IPatternDetails> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }
}

