/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.me.crafting;

import appeng.api.stacks.AEKey;
import java.util.Comparator;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class CraftingStatusEntry
implements Comparable<CraftingStatusEntry> {
    private static final Comparator<CraftingStatusEntry> COMPARATOR = Comparator.comparing(e -> e.getActiveAmount() + e.getPendingAmount()).thenComparing(CraftingStatusEntry::getStoredAmount).reversed();
    private final long serial;
    @Nullable
    private final AEKey what;
    private final long storedAmount;
    private final long activeAmount;
    private final long pendingAmount;

    public CraftingStatusEntry(long serial, @Nullable AEKey what, long storedAmount, long activeAmount, long pendingAmount) {
        this.serial = serial;
        this.what = what;
        this.storedAmount = storedAmount;
        this.activeAmount = activeAmount;
        this.pendingAmount = pendingAmount;
    }

    public long getSerial() {
        return this.serial;
    }

    public long getActiveAmount() {
        return this.activeAmount;
    }

    public long getStoredAmount() {
        return this.storedAmount;
    }

    public long getPendingAmount() {
        return this.pendingAmount;
    }

    public AEKey getWhat() {
        return this.what;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130103_(this.serial);
        buffer.m_130103_(this.activeAmount);
        buffer.m_130103_(this.storedAmount);
        buffer.m_130103_(this.pendingAmount);
        AEKey.writeOptionalKey(buffer, this.what);
    }

    public static CraftingStatusEntry read(FriendlyByteBuf buffer) {
        long serial = buffer.m_130258_();
        long missingAmount = buffer.m_130258_();
        long storedAmount = buffer.m_130258_();
        long craftAmount = buffer.m_130258_();
        AEKey what = AEKey.readOptionalKey(buffer);
        return new CraftingStatusEntry(serial, what, storedAmount, missingAmount, craftAmount);
    }

    public boolean isDeleted() {
        return this.storedAmount == 0L && this.activeAmount == 0L && this.pendingAmount == 0L;
    }

    @Override
    public int compareTo(CraftingStatusEntry o) {
        return COMPARATOR.compare(this, o);
    }
}

