/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.compatibility;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.SingleItemRecipe;

public class CustomRecipeCategory<T extends SingleItemRecipe>
implements IRecipeCategory<T> {
    private static final ResourceLocation RECIPE_GUI_VANILLA = new ResourceLocation("corail_woodcutter", "textures/gui/recipe.png");
    private final RecipeType<T> recipeType;
    private final Component translation;
    private final IDrawable icon;
    private final IDrawable background;

    CustomRecipeCategory(RecipeType<T> recipeType, Component translation, ItemStack icon, IGuiHelper guiHelper) {
        this.recipeType = recipeType;
        this.translation = translation;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon);
        this.background = guiHelper.drawableBuilder(RECIPE_GUI_VANILLA, 0, 0, 72, 18).setTextureSize(72, 18).build();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.translation;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addIngredients((Ingredient)recipe.m_7527_().get(0));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 55, 1).addItemStack(recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()));
    }
}

