/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.entity;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageSavedData;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.api.IUpgradeRenderer;
import net.p3pp3rf1y.sophisticatedcore.client.render.UpgradeRenderRegistry;
import net.p3pp3rf1y.sophisticatedcore.renderdata.IUpgradeRenderData;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.renderdata.UpgradeRenderDataType;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.ITickableUpgrade;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlock;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.BarrelMaterial;
import net.p3pp3rf1y.sophisticatedstorage.block.ChestBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.DynamicRenderTracker;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.IMaterialHolder;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ITintableBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.LimitedBarrelBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.ShulkerBoxBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.block.WoodStorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageOpenersCounter;
import net.p3pp3rf1y.sophisticatedstorage.entity.MovingStorageWrapper;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class StorageHolderBase
implements ILockable,
ICountDisplay,
ITierDisplay,
IUpgradeDisplay,
IFillLevelDisplay,
IMaterialHolder {
    public static final String UPGRADES_VISIBLE_TAG = "upgradesVisible";
    public static final String SORT_BY_TAG = "sortBy";
    private static final String LOCK_VISIBLE_TAG = "lockVisible";
    private static final String COUNTS_VISIBLE_TAG = "countsVisible";
    private static final String FILL_LEVELS_VISIBLE_TAG = "fillLevelsVisible";
    public static final String LOCKED_TAG = "locked";
    @Nullable
    private MovingStorageOpenersCounter openersCounter = null;
    protected boolean updateRenderAttributes = false;
    protected IStorageWrapper storageWrapper = NoopStorageWrapper.INSTANCE;
    protected boolean isMainStorage = true;
    private final boolean showChestUpgradesOnTop;

    protected StorageHolderBase(boolean showChestUpgradesOnTop) {
        this.showChestUpgradesOnTop = showChestUpgradesOnTop;
    }

    private MovingStorageOpenersCounter getOpenersCounter() {
        if (this.openersCounter == null) {
            this.openersCounter = new MovingStorageOpenersCounter(){

                @Override
                protected void onOpen() {
                    if (StorageHolderBase.this.isBarrel()) {
                        StorageHolderBase.this.playSound(SoundEvents.f_11725_);
                        StorageHolderBase.this.updateBarrelOpenBlockState(true);
                    } else if (StorageHolderBase.this.isShulkerBox()) {
                        StorageHolderBase.this.playSound(SoundEvents.f_12409_);
                        StorageBlockEntity storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity();
                        if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                            shulkerBoxBlockEntity.setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.OPENING);
                        }
                    } else if (StorageHolderBase.this.isChest()) {
                        StorageBlockEntity storageBlockEntity;
                        if (StorageHolderBase.this.isMainStorage) {
                            StorageHolderBase.this.playSound(SoundEvents.f_11749_);
                        }
                        if ((storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity()) instanceof ChestBlockEntity) {
                            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                            chestBlockEntity.getChestLidController().m_155377_(true);
                        }
                    }
                }

                @Override
                protected void onClose() {
                    if (StorageHolderBase.this.isBarrel()) {
                        StorageHolderBase.this.playSound(SoundEvents.f_11724_);
                        StorageHolderBase.this.updateBarrelOpenBlockState(false);
                    } else if (StorageHolderBase.this.isShulkerBox()) {
                        StorageHolderBase.this.playSound(SoundEvents.f_12408_);
                        StorageBlockEntity storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity();
                        if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                            ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                            shulkerBoxBlockEntity.setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus.CLOSING);
                        }
                    } else if (StorageHolderBase.this.isChest()) {
                        StorageBlockEntity storageBlockEntity;
                        if (StorageHolderBase.this.isMainStorage) {
                            StorageHolderBase.this.playSound(SoundEvents.f_11747_);
                        }
                        if ((storageBlockEntity = StorageHolderBase.this.getRenderBlockEntity()) instanceof ChestBlockEntity) {
                            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
                            chestBlockEntity.getChestLidController().m_155377_(false);
                        }
                    }
                }

                @Override
                protected boolean isOwnContainer(Player player) {
                    return StorageHolderBase.this.isOwnContainer(player);
                }
            };
        }
        return this.openersCounter;
    }

    protected abstract boolean isOwnContainer(Player var1);

    protected abstract void playSound(SoundEvent var1);

    @Nullable
    protected abstract Entity getEntity();

    public void onStackChanged() {
        this.setSyncedStorageStack(this.getStorageWrapper().getWrappedStorageStack());
        this.updateRenderAttributes = true;
    }

    public void updateStorageWrapper() {
        ItemStack storageItem = this.getSyncedStorageStack();
        if (!NBTHelper.hasTag((ItemStack)storageItem, (String)"uuid")) {
            NBTHelper.setUniqueId((ItemStack)storageItem, (String)"uuid", (UUID)UUID.randomUUID());
            this.setStorageItem(storageItem);
        }
        this.storageWrapper = MovingStorageWrapper.fromStack(storageItem, this::onContentsChanged, this::onStackChanged, this::getStorageData, this::isLocked, this::setLocked, this::isUpgradeRunnable);
    }

    protected boolean isUpgradeRunnable(ItemStack upgrade) {
        return true;
    }

    protected abstract IStorageSavedData getStorageData(UUID var1);

    private void onContentsChanged() {
        if (this.getLevel() == null || this.getLevel().m_5776_()) {
            return;
        }
        ItemStack storageItem = this.getSyncedStorageStack();
        NBTHelper.getUniqueId((ItemStack)storageItem, (String)"uuid").ifPresent(uuid -> this.getStorageData((UUID)uuid).markChanged());
    }

    public void setStorageItem(ItemStack storageItem) {
        this.setSyncedStorageStack(storageItem);
        this.storageWrapper = NoopStorageWrapper.INSTANCE;
        this.updateRenderAttributes = true;
    }

    public IStorageWrapper getStorageWrapper() {
        if (this.isPacked()) {
            return NoopStorageWrapper.INSTANCE;
        }
        if (!this.getSyncedStorageStack().m_41619_() && this.storageWrapper == NoopStorageWrapper.INSTANCE) {
            this.updateStorageWrapper();
        }
        return this.storageWrapper;
    }

    public boolean isBarrel() {
        return this.getSyncedStorageStack().m_41720_() instanceof BarrelBlockItem;
    }

    protected boolean isShulkerBox() {
        return this.getSyncedStorageStack().m_41720_() instanceof ShulkerBoxItem;
    }

    protected boolean isChest() {
        return this.getSyncedStorageStack().m_41720_() instanceof ChestBlockItem;
    }

    public boolean areUpgradesVisible() {
        return NBTHelper.getBoolean((ItemStack)this.getSyncedStorageStack(), (String)UPGRADES_VISIBLE_TAG).orElse(false);
    }

    public boolean areCountsVisible() {
        return NBTHelper.getBoolean((ItemStack)this.getSyncedStorageStack(), (String)COUNTS_VISIBLE_TAG).orElse(true);
    }

    public boolean areFillLevelsVisible() {
        return NBTHelper.getBoolean((ItemStack)this.getSyncedStorageStack(), (String)FILL_LEVELS_VISIBLE_TAG).orElse(false);
    }

    public boolean isLockVisible() {
        return NBTHelper.getBoolean((ItemStack)this.getSyncedStorageStack(), (String)LOCK_VISIBLE_TAG).orElse(true);
    }

    protected boolean isPacked(ItemStack storageItem) {
        return WoodStorageBlockItem.isPacked(this.getSyncedStorageStack());
    }

    public CompoundTag getRenderInfoNbt(ItemStack storageItem) {
        return NBTHelper.getCompound((ItemStack)storageItem, (String)"renderInfo").orElse(new CompoundTag());
    }

    protected abstract void setSyncedStorageStack(ItemStack var1);

    protected abstract ItemStack getSyncedStorageStack();

    protected abstract boolean isLocked(ItemStack var1);

    @Nullable
    protected abstract Level getLevel();

    protected abstract Vec3 getPosition();

    private void updateBarrelOpenBlockState(boolean open) {
        BarrelBlockEntity barrelBlockEntity;
        StorageBlockEntity storageBlockEntity = this.getRenderBlockEntity();
        if (storageBlockEntity instanceof BarrelBlockEntity && !((barrelBlockEntity = (BarrelBlockEntity)storageBlockEntity) instanceof LimitedBarrelBlockEntity)) {
            barrelBlockEntity.m_155250_((BlockState)barrelBlockEntity.m_58900_().m_61124_((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)));
        }
    }

    @Nullable
    public StorageBlockEntity getRenderBlockEntity() {
        StorageBlockEntity renderBlockEntity = this.retrieveRenderBlockEntity();
        if (renderBlockEntity != null) {
            this.updateRenderBlockEntityAttributes(this.getSyncedStorageStack(), renderBlockEntity);
        }
        return renderBlockEntity;
    }

    protected void updateRenderBlockEntityAttributes(ItemStack storageItem, StorageBlockEntity renderBlockEntity) {
        if (this.updateRenderAttributes) {
            Item item;
            this.updateRenderAttributes = false;
            renderBlockEntity.getOpenersCounter().setForPhysicalBlock(false);
            if (renderBlockEntity.isLocked() != this.isLocked(storageItem)) {
                renderBlockEntity.toggleLock();
            }
            if (renderBlockEntity.shouldShowLock() != this.isLockVisible()) {
                renderBlockEntity.toggleLockVisibility();
            }
            if (renderBlockEntity.shouldShowTier() != this.shouldShowTier()) {
                renderBlockEntity.toggleTierVisiblity();
            }
            renderBlockEntity.getStorageWrapper().getRenderInfo().deserializeFrom(this.getRenderInfoNbt(storageItem));
            if (renderBlockEntity.shouldShowUpgrades() != this.areUpgradesVisible()) {
                renderBlockEntity.toggleUpgradesVisiblity();
            }
            if ((item = storageItem.m_41720_()) instanceof ITintableBlockItem) {
                ITintableBlockItem tintableBlockItem = (ITintableBlockItem)item;
                renderBlockEntity.getStorageWrapper().setColors(tintableBlockItem.getMainColor(storageItem).orElse(-1), tintableBlockItem.getAccentColor(storageItem).orElse(-1));
            }
            if (renderBlockEntity instanceof WoodStorageBlockEntity) {
                WoodStorageBlockEntity woodStorage = (WoodStorageBlockEntity)renderBlockEntity;
                WoodStorageBlockItem.getWoodType(storageItem).ifPresent(woodType -> {
                    if (woodStorage.getWoodType() != WoodStorageBlockItem.getWoodType(storageItem)) {
                        woodStorage.setWoodType((WoodType)woodType);
                    }
                });
                boolean isPacked = this.isPacked(storageItem);
                if (woodStorage.isPacked() != isPacked) {
                    woodStorage.setPacked(isPacked);
                }
            }
            if (renderBlockEntity instanceof BarrelBlockEntity) {
                BarrelBlockEntity barrel = (BarrelBlockEntity)renderBlockEntity;
                barrel.setDynamicRenderTracker(new DynamicRenderTracker(barrel){

                    @Override
                    public boolean isDynamicRenderer() {
                        return true;
                    }
                });
                Map<BarrelMaterial, ResourceLocation> materials = BarrelBlockItem.getMaterials(storageItem);
                if (!barrel.getMaterials().equals(materials)) {
                    barrel.setMaterials(materials);
                }
                if (renderBlockEntity instanceof LimitedBarrelBlockEntity) {
                    LimitedBarrelBlockEntity limitedBarrelBlockEntity = (LimitedBarrelBlockEntity)renderBlockEntity;
                    if (limitedBarrelBlockEntity.shouldShowFillLevels() != this.areFillLevelsVisible()) {
                        limitedBarrelBlockEntity.toggleFillLevelVisibility();
                    }
                    if (limitedBarrelBlockEntity.shouldShowCounts() != this.areCountsVisible()) {
                        limitedBarrelBlockEntity.toggleCountVisibility();
                    }
                }
            }
            if (renderBlockEntity instanceof ChestBlockEntity) {
                ChestBlockEntity chestBlockEntity = (ChestBlockEntity)renderBlockEntity;
                chestBlockEntity.showUpgradesOnTop = this.showChestUpgradesOnTop;
            }
        }
    }

    public void startOpen(Player player, Entity entity) {
        if (!player.m_5833_()) {
            this.getOpenersCounter().incrementOpeners(player, entity);
        }
        PiglinAi.m_34873_((Player)player, (boolean)true);
        if (this.getRenderBlockEntity() != null) {
            this.getRenderBlockEntity().startOpen(player);
        }
    }

    public void stopOpen(Player player, Entity entity) {
        if (!player.m_5833_()) {
            this.getOpenersCounter().decrementOpeners(player, entity);
        }
        if (this.getRenderBlockEntity() != null) {
            this.getRenderBlockEntity().stopOpen(player);
        }
    }

    public void tick(Entity entity) {
        Level level = this.getLevel();
        if (level == null) {
            return;
        }
        this.getOpenersCounter().tick(level, entity);
        if (level.m_5776_()) {
            this.clientTick(level);
            return;
        }
        this.runTickableUpgrades(level);
        this.runPickupOnItemEntities(level);
    }

    protected void runTickableUpgrades(Level level) {
        this.getStorageWrapper().getUpgradeHandler().getWrappersThatImplement(ITickableUpgrade.class).forEach(upgrade -> upgrade.tick(this.getEntity(), level, new BlockPos((int)this.getPosition().m_7096_(), (int)this.getPosition().m_7098_(), (int)this.getPosition().m_7094_())));
    }

    private void clientTick(Level level) {
        StorageBlockEntity storageBlockEntity;
        if (this.updateRenderAttributes && this.getRenderBlockEntity() != null) {
            this.updateRenderBlockEntityAttributes(this.getSyncedStorageStack(), this.getRenderBlockEntity());
        }
        if (level.f_46441_.m_188503_(10) == 0) {
            RenderInfo renderInfo = this.getStorageWrapper().getRenderInfo();
            this.renderUpgrades(level, level.f_46441_, renderInfo);
        }
        if ((storageBlockEntity = this.getRenderBlockEntity()) instanceof ChestBlockEntity) {
            ChestBlockEntity chestBlockEntity = (ChestBlockEntity)storageBlockEntity;
            ChestBlockEntity.lidAnimateTick(chestBlockEntity);
        } else {
            storageBlockEntity = this.getRenderBlockEntity();
            if (storageBlockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity shulkerBoxBlockEntity = (ShulkerBoxBlockEntity)storageBlockEntity;
                ShulkerBoxBlockEntity.tick(null, BlockPos.f_121853_, this.getRenderBlockEntity().m_58900_(), shulkerBoxBlockEntity);
            }
        }
    }

    protected void renderUpgrades(Level level, RandomSource rand, RenderInfo renderInfo) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        renderInfo.getUpgradeRenderData().forEach((type, data) -> UpgradeRenderRegistry.getUpgradeRenderer((UpgradeRenderDataType)type).ifPresent(renderer -> this.renderUpgrade((IUpgradeRenderer)renderer, level, rand, (UpgradeRenderDataType<?>)type, (IUpgradeRenderData)data)));
    }

    private <T extends IUpgradeRenderData> void renderUpgrade(IUpgradeRenderer<T> renderer, Level level, RandomSource rand, UpgradeRenderDataType<?> type, IUpgradeRenderData data) {
        type.cast(data).ifPresent(renderData -> renderer.render(level, rand, vector -> vector.add((float)this.getPosition().m_7096_(), (float)this.getPosition().m_7098_() + this.getUpgradeRenderYOffset(), (float)this.getPosition().m_7094_()), renderData));
    }

    protected float getUpgradeRenderYOffset() {
        return 0.8f;
    }

    private void runPickupOnItemEntities(Level level) {
        AABB aabb = this.getPickupBoundingBox();
        List collidedWithItemEntities = level.m_45976_(ItemEntity.class, aabb);
        collidedWithItemEntities.forEach(itemEntity -> {
            if (itemEntity.m_6084_()) {
                this.tryToPickup(level, (ItemEntity)itemEntity);
            }
        });
    }

    protected void tryToPickup(Level level, ItemEntity itemEntity) {
        ItemStack remainingStack = itemEntity.m_32055_().m_41777_();
        remainingStack = InventoryHelper.runPickupOnPickupResponseUpgrades((Level)level, (UpgradeHandler)this.getStorageWrapper().getUpgradeHandler(), (ItemStack)remainingStack, (boolean)false);
        if (remainingStack.m_41613_() < itemEntity.m_32055_().m_41613_()) {
            itemEntity.m_32045_(remainingStack);
        }
    }

    @Nullable
    protected abstract StorageBlockEntity retrieveRenderBlockEntity();

    protected abstract void setLocked(boolean var1);

    protected abstract AABB getPickupBoundingBox();

    public void onStorageItemSynced() {
        StorageBlockEntity renderBlockEntity = this.getRenderBlockEntity();
        if (renderBlockEntity != null && renderBlockEntity.m_58900_().m_60734_().m_5456_() != this.getSyncedStorageStack().m_41720_()) {
            this.refreshRenderBlockEntity();
        }
        this.updateRenderAttributes = true;
        this.storageWrapper = NoopStorageWrapper.INSTANCE;
    }

    protected abstract void refreshRenderBlockEntity();

    public InteractionResult openContainerMenu(Player player) {
        if (this.isPacked(this.getSyncedStorageStack())) {
            return InteractionResult.PASS;
        }
        this.openMenu(player);
        return player.m_9236_().f_46443_ ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
    }

    protected abstract void openMenu(Player var1);

    @Override
    public void toggleLock() {
        boolean locked;
        ItemStack storageItem = this.getSyncedStorageStack();
        boolean bl = locked = !this.isLocked(storageItem);
        if (this.memorizesItemsWhenLocked()) {
            if (locked) {
                ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).selectSlots(0, this.getStorageWrapper().getInventoryHandler().getSlots());
            } else {
                ((MemorySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).unselectAllSlots();
                ItemDisplaySettingsCategory itemDisplaySettings = (ItemDisplaySettingsCategory)this.getStorageWrapper().getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class);
                InventoryHelper.iterate((IItemHandler)this.getStorageWrapper().getInventoryHandler(), (slot, stack) -> {
                    if (stack.m_41619_()) {
                        itemDisplaySettings.itemChanged(slot.intValue());
                    }
                });
            }
        }
        this.setLocked(locked);
        this.setStorageItem(storageItem);
    }

    private boolean memorizesItemsWhenLocked() {
        return MovingStorageWrapper.isLimitedBarrel(this.getSyncedStorageStack());
    }

    @Override
    public boolean isLocked() {
        return this.isLocked(this.getSyncedStorageStack());
    }

    @Override
    public boolean shouldShowLock() {
        return this.isLockVisible();
    }

    @Override
    public void toggleLockVisibility() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.m_41784_().m_128379_(LOCK_VISIBLE_TAG, !this.isLockVisible());
        this.setStorageItem(storageItem);
    }

    @Override
    public boolean shouldShowCounts() {
        return this.areCountsVisible();
    }

    @Override
    public void toggleCountVisibility() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.m_41784_().m_128379_(COUNTS_VISIBLE_TAG, !this.areCountsVisible());
        this.setStorageItem(storageItem);
    }

    @Override
    public List<Integer> getSlotCounts() {
        return MovingStorageWrapper.isLimitedBarrel(this.getSyncedStorageStack()) ? this.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotCounts() : List.of();
    }

    @Override
    public boolean shouldShowFillLevels() {
        return this.areFillLevelsVisible();
    }

    @Override
    public void toggleFillLevelVisibility() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.m_41784_().m_128379_(FILL_LEVELS_VISIBLE_TAG, !this.areFillLevelsVisible());
        this.setStorageItem(storageItem);
    }

    @Override
    public List<Float> getSlotFillLevels() {
        return MovingStorageWrapper.isLimitedBarrel(this.getSyncedStorageStack()) ? this.getStorageWrapper().getRenderInfo().getItemDisplayRenderInfo().getSlotFillRatios() : List.of();
    }

    @Override
    public boolean shouldShowTier() {
        return StorageBlockItem.showsTier(this.getSyncedStorageStack());
    }

    @Override
    public void toggleTierVisiblity() {
        ItemStack storageItem;
        StorageBlockItem.setShowsTier(storageItem, !StorageBlockItem.showsTier(storageItem = this.getSyncedStorageStack()));
        this.setStorageItem(storageItem);
    }

    @Override
    public boolean shouldShowUpgrades() {
        return this.areUpgradesVisible();
    }

    @Override
    public void toggleUpgradesVisiblity() {
        ItemStack storageItem = this.getSyncedStorageStack();
        storageItem.m_41784_().m_128379_(UPGRADES_VISIBLE_TAG, !this.areUpgradesVisible());
        this.setStorageItem(storageItem);
    }

    public boolean isOpen() {
        return this.getOpenersCounter().getOpenerCount() > 0;
    }

    public boolean isPacked() {
        return this.isPacked(this.getSyncedStorageStack());
    }

    @Override
    public void setMaterials(Map<BarrelMaterial, ResourceLocation> materials) {
        ItemStack storageItem = this.getSyncedStorageStack();
        if (this.isBarrel()) {
            BarrelBlockItem.setMaterials(storageItem, materials);
            this.setStorageItem(storageItem);
        }
    }

    @Override
    public Map<BarrelMaterial, ResourceLocation> getMaterials() {
        return this.isBarrel() ? BarrelBlockItem.getMaterials(this.getSyncedStorageStack()) : Collections.emptyMap();
    }

    @Override
    public boolean canHoldMaterials() {
        return this.isBarrel();
    }

    public StorageHolderBase getMainStorageHolder() {
        return this;
    }

    public Optional<StorageHolderBase> getAuxiliaryStorageHolder() {
        return Optional.empty();
    }
}

