/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.misc.Conversion;

public class Transporter {
    public static final String DIMENSION = "Dimension";
    public static final String COORDINATES = "Coordinates";
    public static final String CUSTOM_NAME = "CustomName";
    private final UUID id;
    private final ResourceKey<Level> dimension;
    private final BlockPos blockPos;
    @Nullable
    private final Component name;

    public Transporter(UUID id, ResourceKey<Level> dimension, BlockPos blockPos, Component name) {
        this.id = id;
        this.dimension = dimension;
        this.blockPos = blockPos;
        this.name = name;
    }

    public Transporter(AbstractTransporterEntity transporterEntity) {
        this(transporterEntity.getID(), (ResourceKey<Level>)transporterEntity.m_58904_().m_46472_(), transporterEntity.m_58899_(), transporterEntity.m_7770_());
    }

    public UUID getID() {
        return this.id;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public Component getName() {
        return this.name != null ? this.name : Component.m_237119_();
    }

    public Optional<AbstractTransporterEntity> getTransporterEntity(MinecraftServer server) {
        BlockEntity blockEntity;
        ServerLevel level = server.m_129880_(this.dimension);
        if (level != null && (blockEntity = level.m_7702_(this.blockPos)) instanceof AbstractTransporterEntity) {
            AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
            return Optional.of(transporter);
        }
        return Optional.empty();
    }

    public int getTimeOffset(MinecraftServer server) {
        Optional<AbstractTransporterEntity> transporter = this.getTransporterEntity(server);
        if (transporter.isPresent()) {
            return transporter.get().getTimeOffset();
        }
        return 0;
    }

    public String toString() {
        String nameString = this.name != null ? this.name.getString() : this.id.toString();
        return "[ " + nameString + " | Pos: " + this.blockPos.toString() + " ]";
    }

    public CompoundTag serialize() {
        CompoundTag transporterTag = new CompoundTag();
        ResourceKey<Level> level = this.getDimension();
        BlockPos pos = this.getBlockPos();
        transporterTag.m_128359_(DIMENSION, level.m_135782_().toString());
        transporterTag.m_128385_(COORDINATES, new int[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()});
        if (this.name != null) {
            transporterTag.m_128359_(CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.name));
        }
        return transporterTag;
    }

    public static Transporter deserialize(MinecraftServer server, String idString, CompoundTag tag) {
        UUID id;
        ResourceKey<Level> dimension = Conversion.stringToDimension(tag.m_128461_(DIMENSION));
        BlockPos blockPos = Conversion.intArrayToBlockPos(tag.m_128465_(COORDINATES));
        MutableComponent name = null;
        if (tag.m_128425_(CUSTOM_NAME, 8)) {
            name = Component.Serializer.m_130701_((String)tag.m_128461_(CUSTOM_NAME));
        }
        try {
            id = UUID.fromString(idString);
        }
        catch (IllegalArgumentException e) {
            BlockEntity blockEntity = server.m_129880_(dimension).m_7702_(blockPos);
            if (blockEntity instanceof AbstractTransporterEntity) {
                AbstractTransporterEntity transporter = (AbstractTransporterEntity)blockEntity;
                transporter.setID(transporter.generateID());
                return new Transporter(transporter);
            }
            return null;
        }
        return new Transporter(id, dimension, blockPos, (Component)name);
    }
}

