/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.stargate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.data.Universe;

public class AddressTable {
    private static final String GENERATED = "Generated";
    private static final String EMPTY = StargateJourney.EMPTY;
    public static final ResourceLocation ADDRESS_TABLES_LOCATION = new ResourceLocation("sgjourney", "address_table");
    public static final ResourceKey<Registry<AddressTable>> REGISTRY_KEY = ResourceKey.m_135788_((ResourceLocation)ADDRESS_TABLES_LOCATION);
    public static final Codec<ResourceKey<AddressTable>> RESOURCE_KEY_CODEC = ResourceKey.m_195966_(REGISTRY_KEY);
    private static final Codec<Pair<ResourceKey<Level>, Integer>> DIMENSION_WEIGHT = Codec.pair((Codec)Level.f_46427_.fieldOf("dimension").codec(), (Codec)Codec.INT.fieldOf("weight").codec());
    public static final Codec<AddressTable> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("include_generated_addresses").forGetter(AddressTable::includeGeneratedAddresses), (App)DIMENSION_WEIGHT.listOf().fieldOf("dimensions").forGetter(AddressTable::getDimensions)).apply((Applicative)instance, AddressTable::new));
    private final boolean includeGeneratedAddresses;
    private final List<Pair<ResourceKey<Level>, Integer>> dimensions;

    public AddressTable(boolean includeGeneratedAddresses, List<Pair<ResourceKey<Level>, Integer>> dimensions) {
        this.includeGeneratedAddresses = includeGeneratedAddresses;
        this.dimensions = dimensions;
    }

    public boolean includeGeneratedAddresses() {
        return this.includeGeneratedAddresses;
    }

    public List<Pair<ResourceKey<Level>, Integer>> getDimensions() {
        return this.dimensions;
    }

    public static AddressTable getAddressTable(Level level, ResourceLocation addressTable) {
        RegistryAccess.Frozen registries = level.m_7654_().m_206579_();
        Registry registry = registries.m_175515_(REGISTRY_KEY);
        return (AddressTable)registry.m_7745_(addressTable);
    }

    public static Optional<ResourceKey<Level>> getRandomDimension(Level level, AddressTable addressTable) {
        if (addressTable == null) {
            return Optional.empty();
        }
        ArrayList<Object> dimensions = new ArrayList<Object>();
        if (addressTable.includeGeneratedAddresses()) {
            List<ResourceKey<Level>> generatedDimensions = Universe.get(level).getDimensionsWithGeneratedSolarSystems();
            dimensions.addAll(generatedDimensions);
        }
        List<Pair<ResourceKey<Level>, Integer>> tableDimensions = addressTable.getDimensions();
        for (Pair<ResourceKey<Level>, Integer> dimension : tableDimensions) {
            ResourceKey dimensionKey = (ResourceKey)dimension.getFirst();
            int repeats = (Integer)dimension.getSecond();
            for (int i = 0; i < repeats; ++i) {
                dimensions.add(dimensionKey);
            }
        }
        if (dimensions.size() > 0) {
            Random random = new Random();
            int randomNumber = random.nextInt(dimensions.size());
            return Optional.of((ResourceKey)dimensions.get(randomNumber));
        }
        return Optional.empty();
    }
}

