/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.packets;

import com.mojang.serialization.DynamicOps;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;
import net.povstalec.sgjourney.client.ClientAccess;
import net.povstalec.sgjourney.common.blockstates.StargatePart;

public class ClientboundStargateStateUpdatePacket {
    private static final RegistryOps<Tag> BUILTIN_CONTEXT_OPS = RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_));
    public final BlockPos pos;
    public final boolean canSinkGate;
    public final HashMap<StargatePart, BlockState> blockStates;

    public ClientboundStargateStateUpdatePacket(BlockPos pos, boolean canSinkGate, HashMap<StargatePart, BlockState> blockStates) {
        this.pos = pos;
        this.canSinkGate = canSinkGate;
        this.blockStates = blockStates;
    }

    public ClientboundStargateStateUpdatePacket(FriendlyByteBuf buffer) {
        this(buffer.m_130135_(), buffer.readBoolean(), new HashMap<StargatePart, BlockState>(buffer.m_236847_(buf -> (StargatePart)buf.m_130066_(StargatePart.class), buf -> (BlockState)buf.m_266466_(BUILTIN_CONTEXT_OPS, BlockState.f_61039_))));
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        buffer.writeBoolean(this.canSinkGate);
        buffer.m_236831_(this.blockStates, FriendlyByteBuf::m_130068_, (buf, state) -> buf.m_266332_(BUILTIN_CONTEXT_OPS, BlockState.f_61039_, state));
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientAccess.updateStargateState(this.pos, this.canSinkGate, this.blockStates));
        return true;
    }
}

