/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.misc;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.povstalec.sgjourney.common.blockstates.Orientation;

public class CoordinateHelper {

    public static class Relative {
        public static final Vec3 rotateVector(Vec3 initialVector, Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation) {
            int yRotation;
            Vec3 vector = initialVector;
            int initialHorizontal = initialDirection.m_122416_();
            int destinationHorizontal = destinationDirection.m_122416_();
            Direction.Axis initialRotationAxis = initialDirection.m_122427_().m_122434_();
            Direction.Axis destinationRotationAxis = destinationDirection.m_122427_().m_122434_();
            int initialVertical = initialOrientation.get2DDataValue();
            int destinationVertical = destinationOrientation.get2DDataValue();
            int regular = Orientation.REGULAR.get2DDataValue();
            if (initialVertical > regular) {
                regular += 4;
            }
            int xzRotation1 = regular - initialVertical;
            boolean negativeAxis1 = initialDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
            vector = initialRotationAxis == Direction.Axis.X ? Relative.xRotateClockwise(vector, xzRotation1, negativeAxis1) : Relative.zRotateClockwise(vector, xzRotation1, negativeAxis1);
            if (destinationHorizontal - initialHorizontal - 2 < 0) {
                destinationHorizontal += 4;
            }
            if ((yRotation = destinationHorizontal - initialHorizontal - 2) < 0) {
                yRotation += 4;
            }
            vector = Relative.yRotateClockwise(vector, yRotation);
            if (destinationVertical < Orientation.REGULAR.get2DDataValue()) {
                destinationVertical += 4;
            }
            int xzRotation2 = destinationVertical - Orientation.REGULAR.get2DDataValue();
            boolean negativeAxis2 = destinationDirection.m_122421_() == Direction.AxisDirection.POSITIVE;
            vector = destinationRotationAxis == Direction.Axis.X ? Relative.xRotateClockwise(vector, xzRotation2, negativeAxis2) : Relative.zRotateClockwise(vector, xzRotation2, negativeAxis2);
            return vector;
        }

        public static final Vec3 yRotateClockwise(Vec3 vector, int numberOfRotations) {
            double x = vector.m_7096_();
            double z = vector.m_7094_();
            for (int i = 0; i < numberOfRotations; ++i) {
                double helper = x;
                x = -z;
                z = helper;
            }
            return new Vec3(x, vector.f_82480_, z);
        }

        public static final Vec3 xRotateClockwise(Vec3 vector, int numberOfRotations, boolean clockwise) {
            double y = vector.m_7098_();
            double z = vector.m_7094_();
            int multiplier = clockwise ? 1 : -1;
            for (int i = 0; i < numberOfRotations; ++i) {
                double helper = y;
                y = -z * (double)multiplier;
                z = helper * (double)multiplier;
            }
            return new Vec3(vector.f_82479_, y, z);
        }

        public static final Vec3 zRotateClockwise(Vec3 vector, int numberOfRotations, boolean clockwise) {
            double x = vector.m_7096_();
            double y = vector.m_7098_();
            int multiplier = clockwise ? 1 : -1;
            for (int i = 0; i < numberOfRotations; ++i) {
                double helper = y;
                y = -x * (double)multiplier;
                x = helper * (double)multiplier;
            }
            return new Vec3(x, y, vector.f_82481_);
        }

        public static final Vec3 preserveRelative(Direction initialDirection, Orientation initialOrientation, Direction destinationDirection, Orientation destinationOrientation, Vec3 initial) {
            return Relative.rotateVector(initial, initialDirection, initialOrientation, destinationDirection, destinationOrientation);
        }

        public static final float preserveYRot(Direction initialDirection, Direction destinationDirection, float yRot) {
            float initialStargateDirection = Mth.m_14177_((float)initialDirection.m_122435_());
            float destinationStargateDirection = Mth.m_14177_((float)destinationDirection.m_122435_());
            float relativeRot = destinationStargateDirection - initialStargateDirection;
            yRot = yRot + relativeRot + 180.0f;
            return yRot;
        }

        public static final Vec3i yRotateClockwise(Vec3i vector, int numberOfRotations) {
            int x = vector.m_123341_();
            int z = vector.m_123343_();
            for (int i = 0; i < numberOfRotations; ++i) {
                int helper = x;
                x = -z;
                z = helper;
            }
            return new Vec3i(x, vector.m_123342_(), z);
        }

        public static final Vec3i blockPosOffset(BlockPos initialPos, BlockPos otherPos) {
            return new Vec3i(otherPos.m_123341_() - initialPos.m_123341_(), otherPos.m_123342_() - initialPos.m_123342_(), otherPos.m_123343_() - initialPos.m_123343_());
        }

        public static final Vec3i getRelativeOffset(Direction initialDirection, BlockPos initialPos, BlockPos otherPos) {
            int initialRotation = initialDirection.m_122416_();
            int rotation = -initialRotation;
            if (rotation < 0) {
                rotation += 4;
            }
            Vec3i absoluteOffset = Relative.blockPosOffset(initialPos, otherPos);
            return Relative.yRotateClockwise(absoluteOffset, rotation);
        }

        public static final Vec3i getAbsoluteOffset(Direction initialDirection, Vec3i relativeOffset) {
            if (initialDirection == null) {
                return null;
            }
            int destinationRotation = initialDirection.m_122416_();
            int rotation = destinationRotation;
            if (rotation < 0) {
                rotation += 4;
            }
            return Relative.yRotateClockwise(relativeOffset, rotation);
        }

        public static final BlockPos getOffsetPos(Direction initialDirection, BlockPos initialPos, Vec3i relativeOffset) {
            Vec3i absoluteOffset = Relative.getAbsoluteOffset(initialDirection, relativeOffset);
            if (absoluteOffset == null) {
                return null;
            }
            return initialPos.m_121955_(absoluteOffset);
        }
    }

    public static class CoordinateSystems {
        public static final float cartesianToPolarR(float x, float y) {
            return (float)Math.sqrt(x * x + y * y);
        }

        public static final float cartesianToPolarPhi(float x, float y) {
            return (float)Math.toDegrees(Math.atan2(y, x));
        }

        public static final float polarToCartesianX(float r, float phi) {
            return r * (float)Math.cos(Math.toRadians(phi));
        }

        public static final float polarToCartesianY(float r, float phi) {
            return r * (float)Math.sin(Math.toRadians(phi));
        }
    }
}

