/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.menu;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.SlotItemHandler;
import net.povstalec.sgjourney.common.block_entities.tech.AbstractNaquadahLiquidizerEntity;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.MenuInit;

public abstract class LiquidizerMenu
extends AbstractContainerMenu {
    protected final AbstractNaquadahLiquidizerEntity blockEntity;
    protected final Level level;
    protected FluidStack fluidStack1;
    protected FluidStack fluidStack2;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public LiquidizerMenu(MenuType<LiquidizerMenu> type, int containerId, Inventory inventory, BlockEntity blockEntity) {
        super(type, containerId);
        LiquidizerMenu.m_38869_((Container)inventory, (int)3);
        this.blockEntity = (AbstractNaquadahLiquidizerEntity)blockEntity;
        this.level = inventory.f_35978_.m_9236_();
        this.fluidStack1 = this.blockEntity.getFluid1();
        this.fluidStack2 = this.blockEntity.getFluid2();
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 80, 20));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 34, 20));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 126, 58));
        });
    }

    public void setFluid1(FluidStack fluidStack) {
        this.fluidStack1 = fluidStack;
    }

    public void setFluid2(FluidStack fluidStack) {
        this.fluidStack2 = fluidStack;
    }

    public FluidStack getFluid1() {
        return this.blockEntity.getFluid1();
    }

    public FluidStack getFluid2() {
        return this.blockEntity.getFluid2();
    }

    public Fluid getDesiredFluid1() {
        return this.blockEntity.getDesiredFluid1();
    }

    public Fluid getDesiredFluid2() {
        return this.blockEntity.getDesiredFluid2();
    }

    public int getProgress() {
        return this.blockEntity.progress;
    }

    public boolean m_6875_(Player player) {
        return LiquidizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.NAQUADAH_LIQUIDIZER.get())) || LiquidizerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)player, (Block)((Block)BlockInit.HEAVY_NAQUADAH_LIQUIDIZER.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.m_38903_(sourceStack, 36, 39, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 39) {
            if (!this.m_38903_(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public static class HeavyLiquidNaquadah
    extends LiquidizerMenu {
        public HeavyLiquidNaquadah(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
            this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
        }

        public HeavyLiquidNaquadah(int containerId, Inventory inventory, BlockEntity blockEntity) {
            super((MenuType<LiquidizerMenu>)((MenuType)MenuInit.HEAVY_NAQUADAH_LIQUIDIZER.get()), containerId, inventory, blockEntity);
        }
    }

    public static class LiquidNaquadah
    extends LiquidizerMenu {
        public LiquidNaquadah(int containerId, Inventory inventory, FriendlyByteBuf extraData) {
            this(containerId, inventory, inventory.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
        }

        public LiquidNaquadah(int containerId, Inventory inventory, BlockEntity blockEntity) {
            super((MenuType<LiquidizerMenu>)((MenuType)MenuInit.NAQUADAH_LIQUIDIZER.get()), containerId, inventory, blockEntity);
        }
    }
}

