/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items.crystals;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.capabilities.ItemEnergyProvider;
import net.povstalec.sgjourney.common.config.CommonTechConfig;
import net.povstalec.sgjourney.common.items.crystals.AbstractCrystalItem;
import org.jetbrains.annotations.Nullable;

public class EnergyCrystalItem
extends AbstractCrystalItem {
    public static final String ENERGY_LIMIT = "EnergyLimit";
    public static final String ENERGY = "Energy";

    public EnergyCrystalItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * (float)EnergyCrystalItem.getEnergy(stack) / (float)this.getCapacity());
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, (float)EnergyCrystalItem.getEnergy(stack) / (float)this.getCapacity());
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public static CompoundTag tagSetup(int energy) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(ENERGY, energy);
        return tag;
    }

    public static long getEnergy(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(ENERGY)) {
            tag.m_128405_(ENERGY, 0);
        }
        long energy = tag.m_128435_(ENERGY) == 3 ? (long)tag.m_128451_(ENERGY) : tag.m_128454_(ENERGY);
        return energy;
    }

    public long getCapacity() {
        return (Long)CommonTechConfig.energy_crystal_capacity.get();
    }

    public long getTransfer() {
        return (Long)CommonTechConfig.advanced_energy_crystal_max_transfer.get();
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemEnergyProvider(stack){

            @Override
            public long capacity() {
                return EnergyCrystalItem.this.getCapacity();
            }

            @Override
            public long maxReceive() {
                return EnergyCrystalItem.this.getTransfer();
            }

            @Override
            public long maxExtract() {
                return EnergyCrystalItem.this.getTransfer();
            }
        };
    }

    @Override
    public Optional<Component> descriptionInDHD(ItemStack stack) {
        return Optional.of(Component.m_237115_((String)"tooltip.sgjourney.crystal.in_dhd.energy").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        long energy = EnergyCrystalItem.getEnergy(stack);
        tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.energy").m_7220_((Component)Component.m_237113_((String)(": " + energy + "/" + this.getCapacity() + " FE"))).m_130940_(ChatFormatting.DARK_RED));
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static final class Advanced
    extends EnergyCrystalItem {
        public Advanced(Item.Properties properties) {
            super(properties);
        }

        @Override
        public long getCapacity() {
            return (Long)CommonTechConfig.advanced_energy_crystal_capacity.get();
        }

        @Override
        public long getTransfer() {
            return (Long)CommonTechConfig.advanced_energy_crystal_max_transfer.get();
        }

        @Override
        public boolean isAdvanced() {
            return true;
        }

        @Override
        public Optional<Component> descriptionInDHD(ItemStack stack) {
            return Optional.of(Component.m_237115_((String)"tooltip.sgjourney.crystal.in_dhd.energy.advanced").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        }
    }
}

