/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.povstalec.sgjourney.common.block_entities.tech.TransportRingsEntity;
import net.povstalec.sgjourney.common.capabilities.ItemInventoryProvider;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.MemoryCrystalItem;
import org.jetbrains.annotations.Nullable;

public class RingRemoteItem
extends Item {
    public RingRemoteItem(Item.Properties properties) {
        super(properties);
    }

    public final ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new ItemInventoryProvider(stack){

            @Override
            public int getNumberOfSlots() {
                return 1;
            }

            @Override
            public boolean isValid(int slot, ItemStack stack) {
                return stack.m_150930_((Item)ItemInit.MEMORY_CRYSTAL.get());
            }
        };
    }

    protected List<TransportRingsEntity> getNearbyTransportRings(Level level, BlockPos blockPos, int maxDistance) {
        ArrayList<TransportRingsEntity> transporters = new ArrayList<TransportRingsEntity>();
        for (int x = -maxDistance / 16; x <= maxDistance / 16; ++x) {
            for (int z = -maxDistance / 16; z <= maxDistance / 16; ++z) {
                ChunkAccess chunk = level.m_46865_(blockPos.m_122030_(16 * x).m_122020_(16 * z));
                Set positions = chunk.m_5928_();
                positions.stream().forEach(pos -> {
                    BlockEntity patt2240$temp = level.m_7702_(pos);
                    if (patt2240$temp instanceof TransportRingsEntity) {
                        TransportRingsEntity transportRings = (TransportRingsEntity)patt2240$temp;
                        transporters.add(transportRings);
                    }
                });
            }
        }
        return transporters;
    }

    private double distance(BlockPos pos, BlockPos targetPos) {
        int x = Math.abs(targetPos.m_123341_() - pos.m_123341_());
        int y = Math.abs(targetPos.m_123342_() - pos.m_123342_());
        int z = Math.abs(targetPos.m_123343_() - pos.m_123343_());
        return Math.sqrt(x * x + y * y + z * z);
    }

    public Optional<TransportRingsEntity> findNearestTransportRings(Level level, BlockPos blockPos, int maxDistance) {
        List<TransportRingsEntity> transporters = this.getNearbyTransportRings(level, blockPos, maxDistance);
        transporters.sort((stargateA, stargateB) -> Double.valueOf(this.distance(blockPos, stargateA.m_58899_())).compareTo(this.distance(blockPos, stargateB.m_58899_())));
        if (!transporters.isEmpty()) {
            return Optional.of(transporters.get(0));
        }
        return Optional.empty();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (player.m_6144_() && !level.m_5776_()) {
            ItemStack mainHandStack = player.m_21120_(InteractionHand.MAIN_HAND);
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            if (offHandStack.m_150930_((Item)ItemInit.RING_REMOTE.get())) {
                offHandStack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    ItemStack returnStack = !mainHandStack.m_41619_() ? itemHandler.insertItem(0, mainHandStack, false) : itemHandler.extractItem(0, 1, false);
                    player.m_21008_(InteractionHand.MAIN_HAND, returnStack);
                });
            }
        } else if (!player.m_6144_()) {
            ItemStack stack = player.m_21120_(hand);
            if (!RingRemoteItem.canActivate(stack)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.no_memory_crystal").m_130940_(ChatFormatting.BLUE), true);
            } else if (!level.m_5776_()) {
                stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                    ItemStack crystalStack = itemHandler.getStackInSlot(0);
                    int[] coordinates = null;
                    for (int i = 0; i < MemoryCrystalItem.getMemoryListSize(crystalStack) && (coordinates = MemoryCrystalItem.getCoordinatesAt(crystalStack, i)) == null; ++i) {
                    }
                    if (coordinates != null) {
                        BlockPos targetPos = new BlockPos(coordinates[0], coordinates[1], coordinates[2]);
                        Optional<TransportRingsEntity> transportRings = this.findNearestTransportRings(level, player.m_20183_(), 16);
                        if (transportRings.isPresent()) {
                            BlockEntity patt5197$temp = level.m_7702_(targetPos);
                            if (patt5197$temp instanceof TransportRingsEntity) {
                                TransportRingsEntity targetRings = (TransportRingsEntity)patt5197$temp;
                                if (transportRings.get().canTransport() && targetRings.canTransport()) {
                                    transportRings.get().activate(targetPos);
                                } else {
                                    player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.transport_rings_busy").m_130940_(ChatFormatting.BLUE), true);
                                }
                            }
                        } else {
                            player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.no_transport_rings_nearby").m_130940_(ChatFormatting.BLUE), true);
                        }
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)"message.sgjourney.ring_remote.error.no_coordinates").m_130940_(ChatFormatting.BLUE), true);
                    }
                });
            }
        }
        return InteractionResultHolder.m_19092_((Object)itemstack, (boolean)level.m_5776_());
    }

    public static boolean canActivate(ItemStack stack) {
        if (stack.m_150930_((Item)ItemInit.RING_REMOTE.get())) {
            Optional canActivate = stack.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> !itemHandler.getStackInSlot(0).m_41619_());
            return canActivate.isPresent() ? (Boolean)canActivate.get() : false;
        }
        return false;
    }

    private int[] findFirstCoords(ItemStack memoryCrystal) {
        int[] address = new int[]{};
        for (int i = 0; i < MemoryCrystalItem.getMemoryListSize(memoryCrystal); ++i) {
            address = MemoryCrystalItem.getAddressAt(memoryCrystal, i);
            if (address.length <= 0) continue;
            return address;
        }
        return address;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            ItemStack memoryCrystal = itemHandler.getStackInSlot(0);
            if (memoryCrystal.m_41720_() instanceof MemoryCrystalItem) {
                tooltipComponents.add((Component)Component.m_237115_((String)"item.sgjourney.memory_crystal").m_130940_(ChatFormatting.BLUE));
                int[] firstCoords = this.findFirstCoords(memoryCrystal);
                if (firstCoords.length == 3) {
                    tooltipComponents.add((Component)Component.m_237113_((String)("X: " + firstCoords[0] + " Y: " + firstCoords[1] + " Z: " + firstCoords[2])).m_130940_(ChatFormatting.YELLOW));
                }
                super.m_7373_(stack, level, tooltipComponents, isAdvanced);
            }
        });
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }
}

