/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blockstates;

import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public enum Orientation implements StringRepresentable
{
    REGULAR("regular", 1, 0),
    UPWARD("upward", 0, 1),
    DOWNWARD("downward", 2, -1);

    private String name;
    private int data2d;
    private int index;

    private Orientation(String name, int data2d, int index) {
        this.name = name;
        this.data2d = data2d;
        this.index = index;
    }

    public String m_7912_() {
        return this.name;
    }

    public int get2DDataValue() {
        return this.data2d;
    }

    public int getIndex() {
        return this.index;
    }

    public static Orientation getOrientationFromXRot(Player player) {
        if (player == null) {
            return REGULAR;
        }
        float rotation = player.m_146909_();
        if (rotation > 65.0f) {
            return UPWARD;
        }
        if (rotation < -65.0f) {
            return DOWNWARD;
        }
        return REGULAR;
    }

    public static Direction getCenterDirection(Direction facingDirection, Orientation orientation) {
        if (orientation != null && facingDirection != null) {
            switch (orientation) {
                case UPWARD: {
                    return facingDirection.m_122424_();
                }
                case DOWNWARD: {
                    return facingDirection;
                }
            }
        }
        return Direction.UP;
    }

    public static Direction getEffectiveDirection(Direction facingDirection, Orientation orientation) {
        if (orientation != null) {
            switch (orientation) {
                case UPWARD: {
                    return Direction.UP;
                }
                case DOWNWARD: {
                    return Direction.DOWN;
                }
            }
        }
        return facingDirection;
    }

    public static Direction getMultiDirection(Direction facingDirection, Direction direction, Orientation orientation) {
        if (orientation == REGULAR) {
            return direction;
        }
        if (direction != null) {
            switch (direction) {
                case UP: {
                    return orientation == UPWARD ? facingDirection.m_122424_() : facingDirection;
                }
                case DOWN: {
                    return orientation == UPWARD ? facingDirection : facingDirection.m_122424_();
                }
            }
            return Orientation.getEffectiveDirection(facingDirection, orientation);
        }
        return facingDirection;
    }

    public static Vec3 getEffectiveVector(Direction facingDirection, Orientation orientation) {
        if (orientation != null) {
            switch (orientation) {
                case UPWARD: {
                    return new Vec3(0.0, 1.0, 0.0);
                }
                case DOWNWARD: {
                    return new Vec3(0.0, -1.0, 0.0);
                }
            }
        }
        Vec3i facingNormal = facingDirection.m_122436_();
        return new Vec3((double)facingNormal.m_123341_(), (double)facingNormal.m_123342_(), (double)facingNormal.m_123343_());
    }
}

