/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.povstalec.sgjourney.common.block_entities.SymbolBlockEntity;
import net.povstalec.sgjourney.common.blockstates.Orientation;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.stargate.PointOfOrigin;
import net.povstalec.sgjourney.common.stargate.Symbols;

public abstract class SymbolBlock
extends DirectionalBlock
implements EntityBlock {
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);

    protected SymbolBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_52588_, (Comparable)Direction.NORTH)).m_61124_(ORIENTATION, (Comparable)((Object)Orientation.REGULAR)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_52588_}).m_61104_(new Property[]{ORIENTATION});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)f_52588_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)f_52588_)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_52588_, (Comparable)context.m_8125_().m_122424_())).m_61124_(ORIENTATION, (Comparable)((Object)Orientation.getOrientationFromXRot(context.m_43723_())));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.m_5776_()) {
            return (localLevel, pos, blockState, entity) -> {
                if (entity instanceof SymbolBlockEntity) {
                    SymbolBlockEntity symbol = (SymbolBlockEntity)entity;
                    symbol.tick(localLevel, pos, blockState);
                }
            };
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            BlockEntity blockEntity;
            if (!level.m_5776_() && (blockEntity = level.m_7702_(pos)) instanceof SymbolBlockEntity) {
                MutableComponent text;
                SymbolBlockEntity symbolBlock = (SymbolBlockEntity)blockEntity;
                int symbolNumber = symbolBlock.getSymbolNumber();
                player.m_213846_((Component)Component.m_237115_((String)"info.sgjourney.symbol_number").m_7220_((Component)Component.m_237113_((String)(": " + symbolNumber))).m_130940_(ChatFormatting.YELLOW));
                if (symbolNumber == 0) {
                    MutableComponent pointOfOrigin = Component.m_237113_((String)symbolBlock.getPointOfOrigin().toString());
                    text = Component.m_237115_((String)"info.sgjourney.point_of_origin").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)pointOfOrigin).m_130940_(ChatFormatting.DARK_PURPLE);
                } else {
                    MutableComponent symbols = Component.m_237113_((String)symbolBlock.getSymbols().toString());
                    text = Component.m_237115_((String)"info.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)symbols).m_130940_(ChatFormatting.LIGHT_PURPLE);
                }
                player.m_213846_((Component)text);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public abstract ItemLike getItem();

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (!level.m_5776_() && !player.m_7500_() && player.m_36298_(state)) {
            ItemStack itemstack = new ItemStack(this.getItem());
            blockentity.m_187476_(itemstack);
            ItemEntity itementity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter getter, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        RegistryAccess registries = clientPacketListener.m_105152_();
        int symbolNumber = 0;
        String symbol = "";
        String symbols = "";
        if (stack.m_41782_() && stack.m_41783_().m_128441_("BlockEntityTag")) {
            CompoundTag blockEntityTag = stack.m_41783_().m_128469_("BlockEntityTag");
            if (blockEntityTag.m_128441_("SymbolNumber")) {
                symbolNumber = blockEntityTag.m_128451_("SymbolNumber");
            }
            if (symbolNumber == 0 && blockEntityTag.m_128441_("Symbol")) {
                Registry pointOfOriginRegistry;
                String pointOfOrigin = blockEntityTag.m_128461_("Symbol");
                ResourceLocation location = ResourceLocation.m_135820_((String)pointOfOrigin);
                symbol = location == null ? "Invalid Path" : ((pointOfOriginRegistry = registries.m_175515_(PointOfOrigin.REGISTRY_KEY)).m_7745_(new ResourceLocation(pointOfOrigin)) != null ? ((PointOfOrigin)pointOfOriginRegistry.m_7745_(new ResourceLocation(pointOfOrigin))).getName() : "Error");
            }
            if (symbolNumber != 0 && blockEntityTag.m_128441_("Symbols")) {
                Registry symbolsRegistry;
                ResourceLocation location = ResourceLocation.m_135820_((String)blockEntityTag.m_128461_("Symbols"));
                symbols = location == null ? "Invalid Path" : ((symbolsRegistry = registries.m_175515_(Symbols.REGISTRY_KEY)).m_7745_(new ResourceLocation(symbols)) != null ? ((Symbols)symbolsRegistry.m_7745_(new ResourceLocation(symbols))).getName() : "Error");
            }
        }
        if (symbolNumber == 0) {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.symbol").m_7220_((Component)Component.m_237113_((String)": ").m_7220_((Component)Component.m_237115_((String)symbol))).m_130940_(ChatFormatting.DARK_PURPLE));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.symbol_number").m_7220_((Component)Component.m_237113_((String)": ").m_130946_("" + symbolNumber)).m_130940_(ChatFormatting.YELLOW));
            tooltipComponents.add((Component)Component.m_237115_((String)"tooltip.sgjourney.symbols").m_7220_((Component)Component.m_237113_((String)": ").m_7220_((Component)Component.m_237115_((String)symbols))).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
        super.m_5871_(stack, getter, tooltipComponents, isAdvanced);
    }

    public static class RedSandstone
    extends SymbolBlock {
        public RedSandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new SymbolBlockEntity.RedSandstone(pos, state);
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.RED_SANDSTONE_SYMBOL.get();
        }
    }

    public static class Sandstone
    extends SymbolBlock {
        public Sandstone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new SymbolBlockEntity.Sandstone(pos, state);
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.SANDSTONE_SYMBOL.get();
        }
    }

    public static class Stone
    extends SymbolBlock {
        public Stone(BlockBehaviour.Properties properties) {
            super(properties);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new SymbolBlockEntity.Stone(pos, state);
        }

        @Override
        public ItemLike getItem() {
            return (ItemLike)BlockInit.STONE_SYMBOL.get();
        }
    }
}

