/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.block_entities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.PacketDistributor;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.EnergyBlockEntity;
import net.povstalec.sgjourney.common.blocks.tech.NaquadahGeneratorBlock;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.init.PacketHandlerInit;
import net.povstalec.sgjourney.common.items.NaquadahFuelRodItem;
import net.povstalec.sgjourney.common.packets.ClientboundNaquadahGeneratorUpdatePacket;
import org.jetbrains.annotations.NotNull;

public abstract class NaquadahGeneratorEntity
extends EnergyBlockEntity {
    private int reactionProgress = 0;
    private final ItemStackHandler itemHandler = this.createHandler();
    private final LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.of(() -> this.itemHandler);

    public NaquadahGeneratorEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, true);
    }

    @Override
    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("Inventory"));
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128365_("Inventory", (Tag)this.itemHandler.serializeNBT());
    }

    public boolean hasNaquadah() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.m_41720_() instanceof NaquadahFuelRodItem) {
            return NaquadahFuelRodItem.getFuel(stack) > 0;
        }
        return false;
    }

    public void setReactionProgress(int reactionProgress) {
        this.reactionProgress = reactionProgress;
    }

    public int getReactionProgress() {
        return this.reactionProgress;
    }

    public abstract long getReactionTime();

    public abstract long getEnergyPerTick();

    @Nullable
    public Direction getDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof NaquadahGeneratorBlock) {
            FrontAndTop orientation = (FrontAndTop)gateState.m_61143_(NaquadahGeneratorBlock.ORIENTATION);
            if (orientation.m_122629_() == Direction.UP) {
                return orientation.m_122625_();
            }
            return orientation.m_122629_();
        }
        StargateJourney.LOGGER.error("Couldn't find Direction " + this.m_58899_().toString());
        return null;
    }

    @Nullable
    public Direction getBottomDirection() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof NaquadahGeneratorBlock) {
            FrontAndTop orientation = (FrontAndTop)gateState.m_61143_(NaquadahGeneratorBlock.ORIENTATION);
            return orientation.m_122625_();
        }
        StargateJourney.LOGGER.error("Couldn't find Direction " + this.m_58899_().toString());
        return null;
    }

    public boolean isActive() {
        BlockPos gatePos = this.m_58899_();
        BlockState gateState = this.f_58857_.m_8055_(gatePos);
        if (gateState.m_60734_() instanceof NaquadahGeneratorBlock) {
            return (Boolean)gateState.m_61143_((Property)NaquadahGeneratorBlock.ACTIVE);
        }
        StargateJourney.LOGGER.error("Couldn't find Active state" + this.m_58899_().toString());
        return false;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                NaquadahGeneratorEntity.this.m_6596_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() == ItemInit.NAQUADAH_FUEL_ROD.get();
                    }
                }
                return false;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    @Override
    protected boolean isCorrectEnergySide(Direction side) {
        Direction direction = this.getDirection();
        Direction bottom = this.getBottomDirection();
        if (direction != null && bottom != null) {
            return side == bottom || side == direction.m_122427_() || side == direction.m_122428_();
        }
        return false;
    }

    @Override
    protected boolean receivesEnergy() {
        return false;
    }

    private void doReaction() {
        if (!this.isActive()) {
            return;
        }
        if (this.hasNaquadah() && this.reactionProgress == 0) {
            if (NaquadahFuelRodItem.depleteFuel(this.itemHandler.getStackInSlot(0))) {
                this.progressReaction();
            } else {
                this.itemHandler.extractItem(0, 1, false);
            }
        } else if (this.reactionProgress > 0 && (long)this.reactionProgress < this.getReactionTime() && this.getEnergyStored() < this.capacity() && this.canReceive(this.getEnergyPerTick())) {
            this.progressReaction();
        } else if ((long)this.reactionProgress >= this.getReactionTime()) {
            this.reactionProgress = 0;
        }
    }

    private void progressReaction() {
        this.generateEnergy(this.getEnergyPerTick());
        ++this.reactionProgress;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, NaquadahGeneratorEntity generator) {
        if (level.f_46443_) {
            return;
        }
        generator.doReaction();
        generator.outputEnergy(Direction.DOWN);
        Direction direction = generator.getDirection();
        if (direction != null) {
            generator.outputEnergy(direction.m_122427_());
            generator.outputEnergy(direction.m_122428_());
        }
        PacketHandlerInit.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(generator.f_58858_)), (Object)new ClientboundNaquadahGeneratorUpdatePacket(generator.f_58858_, generator.getReactionProgress(), generator.getEnergyStored()));
    }
}

