/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.povstalec.sgjourney.common.block_entities.tech.TransportRingsEntity;

public class TransportRingsModel {
    private static final ResourceLocation TRANSPORT_RINGS_TEXTURE = new ResourceLocation("sgjourney", "textures/block/transport_rings.png");
    private final ModelPart transportRings;

    public TransportRingsModel(ModelPart transportRings) {
        this.transportRings = transportRings;
    }

    public void setRingHeight(int ring, float height) {
        if (ring < 1 && ring > 5) {
            return;
        }
        this.getRing(ring).m_104227_(0.0f, height, 0.0f);
    }

    public ModelPart getRing(int ring) {
        return this.transportRings.m_171324_("transport_ring_" + ring);
    }

    public void renderTransportRings(TransportRingsEntity transportRings, float partialTick, PoseStack stack, MultiBufferSource source, int combinedLight, int combinedOverlay) {
        VertexConsumer ringTexture = source.m_6299_(RenderType.m_110446_((ResourceLocation)TRANSPORT_RINGS_TEXTURE));
        this.transportRings.m_104301_(stack, ringTexture, combinedLight, combinedOverlay);
    }

    public static LayerDefinition createRingLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition first_ring = partdefinition.m_171599_("transport_ring_1", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition second_ring = partdefinition.m_171599_("transport_ring_2", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition third_ring = partdefinition.m_171599_("transport_ring_3", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition fourth_ring = partdefinition.m_171599_("transport_ring_4", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        PartDefinition fifth_ring = partdefinition.m_171599_("transport_ring_5", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)8.0f, (float)0.0f, (float)8.0f));
        TransportRingsModel.createRing(first_ring);
        TransportRingsModel.createRing(second_ring);
        TransportRingsModel.createRing(third_ring);
        TransportRingsModel.createRing(fourth_ring);
        TransportRingsModel.createRing(fifth_ring);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public static void createRing(PartDefinition ring) {
        for (int i = 0; i < 16; ++i) {
            ring.m_171599_("ring_" + i, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -2.0f, 32.219f, 16.0f, 4.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)((float)Math.toRadians(22.5 * (double)i)), (float)0.0f));
        }
    }
}

