/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.gateways.gate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.gateways.Gateways;
import dev.shadowsoffire.gateways.entity.GatewayEntity;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import java.text.DecimalFormat;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public interface Failure
extends CodecProvider<Failure> {
    public static final CodecMap<Failure> CODEC = new CodecMap("Gateway Failure");

    public void onFailure(ServerLevel var1, GatewayEntity var2, Player var3, GatewayEntity.FailureReason var4);

    public void appendHoverText(Consumer<MutableComponent> var1);

    public static void initSerializers() {
        Failure.register("explosion", ExplosionFailure.CODEC);
        Failure.register("mob_effect", MobEffectFailure.CODEC);
        Failure.register("summon", SummonFailure.CODEC);
        Failure.register("chanced", ChancedFailure.CODEC);
        Failure.register("command", CommandFailure.CODEC);
    }

    private static void register(String id, Codec<? extends Failure> codec) {
        CODEC.register(Gateways.loc(id), codec);
    }

    public record ExplosionFailure(float strength, boolean fire, boolean blockDamage) implements Failure
    {
        public static Codec<ExplosionFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("strength").forGetter(ExplosionFailure::strength), (App)Codec.BOOL.fieldOf("fire").forGetter(ExplosionFailure::fire), (App)Codec.BOOL.fieldOf("block_damage").forGetter(ExplosionFailure::blockDamage)).apply((Applicative)inst, ExplosionFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.m_255391_((Entity)gate, gate.m_20185_(), gate.m_20186_(), gate.m_20189_(), this.strength, this.fire, this.blockDamage ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE);
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"failure.gateways.explosion", (Object[])new Object[]{Float.valueOf(this.strength), this.fire, this.blockDamage}));
        }
    }

    public record MobEffectFailure(MobEffect effect, int duration, int amplifier) implements Failure
    {
        public static Codec<MobEffectFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(MobEffectFailure::effect), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectFailure::duration), (App)PlaceboCodecs.nullableField((Codec)Codec.INT, (String)"amplifier", (Object)0).forGetter(MobEffectFailure::amplifier)).apply((Applicative)inst, MobEffectFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            level.m_45955_(TargetingConditions.m_148353_(), null, gate.m_20191_().m_82400_(gate.getGateway().rules().leashRange())).forEach(p -> p.m_7292_(new MobEffectInstance(this.effect, this.duration, this.amplifier)));
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"failure.gateways.mob_effect", (Object[])new Object[]{MobEffectFailure.toComponent(new MobEffectInstance(this.effect, this.duration, this.amplifier))}));
        }

        private static Component toComponent(MobEffectInstance mobeffectinstance) {
            MutableComponent mutablecomponent = Component.m_237115_((String)mobeffectinstance.m_19576_());
            MobEffect mobeffect = mobeffectinstance.m_19544_();
            if (mobeffectinstance.m_19564_() > 0) {
                mutablecomponent = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutablecomponent, Component.m_237115_((String)("potion.potency." + mobeffectinstance.m_19564_()))});
            }
            if (mobeffectinstance.m_19557_() > 20) {
                mutablecomponent = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutablecomponent, MobEffectUtil.m_267641_((MobEffectInstance)mobeffectinstance, (float)1.0f)});
            }
            return mutablecomponent.m_130940_(mobeffect.m_19483_().m_19497_());
        }
    }

    public record SummonFailure(WaveEntity entity) implements Failure
    {
        public static Codec<SummonFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)WaveEntity.CODEC.fieldOf("entity").forGetter(SummonFailure::entity)).apply((Applicative)inst, SummonFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            for (int i = 0; i < this.entity.getCount(); ++i) {
                LivingEntity ent = this.entity.createEntity((Level)level);
                if (ent == null) continue;
                Vec3 pos = gate.getGateway().spawnAlgo().spawn(level, gate.m_20182_(), gate, (Entity)ent);
                ent.m_146884_(pos != null ? pos : gate.m_20182_());
                level.m_7967_((Entity)ent);
            }
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237110_((String)"failure.gateways.summon", (Object[])new Object[]{this.entity.getDescription()}));
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }
    }

    public record ChancedFailure(Failure failure, float chance) implements Failure
    {
        public static Codec<ChancedFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.fieldOf("failure").forGetter(ChancedFailure::failure), (App)Codec.FLOAT.fieldOf("chance").forGetter(ChancedFailure::chance)).apply((Applicative)inst, ChancedFailure::new));
        static DecimalFormat fmt = new DecimalFormat("##.##%");

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            if (level.f_46441_.m_188501_() < this.chance) {
                this.failure.onFailure(level, gate, summoner, reason);
            }
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            this.failure.appendHoverText(c -> list.accept(Component.m_237110_((String)"failure.gateways.chance", (Object[])new Object[]{fmt.format(this.chance * 100.0f), c})));
        }
    }

    public record CommandFailure(String command, String desc) implements Failure
    {
        public static Codec<CommandFailure> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("command").forGetter(CommandFailure::command), (App)Codec.STRING.fieldOf("desc").forGetter(CommandFailure::desc)).apply((Applicative)inst, CommandFailure::new));

        @Override
        public void onFailure(ServerLevel level, GatewayEntity gate, Player summoner, GatewayEntity.FailureReason reason) {
            String realCmd = this.command.replace("<summoner>", summoner.m_36316_().getName());
            level.m_7654_().m_129892_().m_230957_(gate.m_20203_(), realCmd);
        }

        public Codec<? extends Failure> getCodec() {
            return CODEC;
        }

        @Override
        public void appendHoverText(Consumer<MutableComponent> list) {
            list.accept(Component.m_237115_((String)this.desc));
        }
    }
}

