/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.tileentity;

import com.blakebr0.cucumber.energy.DynamicEnergyStorage;
import com.blakebr0.cucumber.helper.CropHelper;
import com.blakebr0.cucumber.helper.StackHelper;
import com.blakebr0.cucumber.inventory.BaseItemStackHandler;
import com.blakebr0.cucumber.tileentity.BaseInventoryTileEntity;
import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.block.HarvesterBlock;
import com.blakebr0.mysticalagriculture.container.HarvesterContainer;
import com.blakebr0.mysticalagriculture.container.inventory.UpgradeItemStackHandler;
import com.blakebr0.mysticalagriculture.init.ModTileEntities;
import com.blakebr0.mysticalagriculture.util.IUpgradeableMachine;
import com.blakebr0.mysticalagriculture.util.MachineUpgradeTier;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;

public class HarvesterTileEntity
extends BaseInventoryTileEntity
implements MenuProvider,
IUpgradeableMachine {
    private static final int FUEL_TICK_MULTIPLIER = 20;
    public static final int OPERATION_TIME = 100;
    public static final int FUEL_USAGE = 40;
    public static final int SCAN_FUEL_USAGE = 10;
    public static final int FUEL_CAPACITY = 80000;
    public static final int BASE_RANGE = 1;
    private final BaseItemStackHandler inventory;
    private final UpgradeItemStackHandler upgradeInventory;
    private final DynamicEnergyStorage energy;
    private final LazyOptional<IEnergyStorage> energyCapability = LazyOptional.of(this::getEnergy);
    private MachineUpgradeTier tier;
    private Direction direction;
    private int progress;
    private int fuelLeft;
    private int fuelItemValue;
    private int lastScanIndex = -1;
    private boolean isRunning;

    public HarvesterTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.HARVESTER.get(), pos, state);
        this.inventory = HarvesterTileEntity.createInventoryHandler(() -> ((HarvesterTileEntity)this).setChangedFast());
        this.upgradeInventory = new UpgradeItemStackHandler();
        this.energy = new DynamicEnergyStorage(80000, () -> ((HarvesterTileEntity)this).setChangedFast());
    }

    public BaseItemStackHandler getInventory() {
        return this.inventory;
    }

    public Component m_5446_() {
        return Localizable.of((String)"container.mysticalagriculture.harvester").build();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return HarvesterContainer.create(i, inventory, this.inventory, this.upgradeInventory, this.m_58899_());
    }

    @Override
    public UpgradeItemStackHandler getUpgradeInventory() {
        return this.upgradeInventory;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.progress = tag.m_128451_("Progress");
        this.fuelLeft = tag.m_128451_("FuelLeft");
        this.fuelItemValue = tag.m_128451_("FuelItemValue");
        this.lastScanIndex = tag.m_128451_("LastScanIndex");
        this.energy.deserializeNBT(tag.m_128423_("Energy"));
        this.upgradeInventory.deserializeNBT(tag.m_128469_("UpgradeInventory"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("Progress", this.progress);
        tag.m_128405_("FuelLeft", this.fuelLeft);
        tag.m_128405_("FuelItemValue", this.fuelItemValue);
        tag.m_128405_("LastScanIndex", this.lastScanIndex);
        tag.m_128405_("Energy", this.energy.getEnergyStored());
        tag.m_128365_("UpgradeInventory", (Tag)this.upgradeInventory.serializeNBT());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.m_58901_() && cap == ForgeCapabilities.ENERGY) {
            return ForgeCapabilities.ENERGY.orEmpty(cap, this.energyCapability);
        }
        return super.getCapability(cap, side);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HarvesterTileEntity tile) {
        if (tile.energy.getEnergyStored() < tile.energy.getMaxEnergyStored()) {
            ItemStack fuel = tile.inventory.getStackInSlot(0);
            if (tile.fuelLeft <= 0 && !fuel.m_41619_()) {
                tile.fuelItemValue = ForgeHooks.getBurnTime((ItemStack)fuel, null);
                if (tile.fuelItemValue > 0) {
                    tile.fuelLeft = tile.fuelItemValue *= 20;
                    tile.inventory.setStackInSlot(0, StackHelper.shrink((ItemStack)fuel, (int)1, (boolean)true));
                    tile.setChangedFast();
                }
            }
            if (tile.fuelLeft > 0) {
                int fuelPerTick = Math.min(Math.min(tile.fuelLeft, tile.getFuelUsage() * 2), tile.energy.getMaxEnergyStored() - tile.energy.getEnergyStored());
                tile.fuelLeft -= tile.energy.receiveEnergy(fuelPerTick, false);
                if (tile.fuelLeft <= 0) {
                    tile.fuelItemValue = 0;
                }
                tile.setChangedFast();
            }
        }
        MachineUpgradeTier tier = tile.getMachineTier();
        Direction direction = (Direction)state.m_61143_((Property)HarvesterBlock.FACING);
        if (tier != tile.tier || direction != tile.direction) {
            tile.tier = tier;
            tile.direction = direction;
            if (tier == null) {
                tile.energy.resetMaxEnergyStorage();
            } else {
                tile.energy.setMaxEnergyStorage((int)(80000.0 * tier.getFuelCapacityMultiplier()));
            }
            tile.setChangedFast();
        }
        boolean isDisabled = level.m_276867_(tile.m_58899_());
        int operationTime = tile.getOperationTime();
        if (tile.progress > operationTime && !isDisabled) {
            BlockPos nextPos = tile.findNextPosition();
            BlockState cropState = level.m_8055_(nextPos);
            Block block = cropState.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                Item seed = CropHelper.getSeedsItem((Block)block);
                if (seed != null && crop.m_52307_(cropState)) {
                    List drops = Block.m_49869_((BlockState)cropState, (ServerLevel)((ServerLevel)level), (BlockPos)nextPos, (BlockEntity)tile);
                    for (ItemStack drop : drops) {
                        Item item = drop.m_41720_();
                        if (drop.m_41619_() || item != seed) continue;
                        drop.m_41774_(1);
                        break;
                    }
                    for (ItemStack drop : drops) {
                        if (drop.m_41619_()) continue;
                        tile.addItemToInventory(drop, level, nextPos);
                    }
                    level.m_46597_(nextPos, crop.m_52289_(0));
                    tile.energy.extractEnergy(tile.getFuelUsage(), false);
                } else {
                    tile.energy.extractEnergy(10, false);
                }
            }
            tile.progress = 0;
            tile.setChangedFast();
        }
        boolean wasRunning = tile.isRunning;
        if (!isDisabled && tile.energy.getEnergyStored() >= tile.getFuelUsage()) {
            ++tile.progress;
            tile.isRunning = true;
            tile.setChangedFast();
        } else {
            tile.isRunning = false;
        }
        if (wasRunning != tile.isRunning) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)HarvesterBlock.RUNNING, (Comparable)Boolean.valueOf(tile.isRunning)), 3);
            tile.setChangedFast();
        }
        tile.dispatchIfChanged();
    }

    public static BaseItemStackHandler createInventoryHandler() {
        return HarvesterTileEntity.createInventoryHandler(null);
    }

    public static BaseItemStackHandler createInventoryHandler(Runnable onContentsChanged) {
        return BaseItemStackHandler.create((int)16, (Runnable)onContentsChanged, builder -> {
            builder.setCanInsert((slot, stack) -> slot == 0 && FurnaceBlockEntity.m_58399_((ItemStack)stack));
            builder.setCanExtract(slot -> slot > 0 || slot == 0 && !FurnaceBlockEntity.m_58399_((ItemStack)builder.getStackInSlot(slot.intValue())));
        });
    }

    public DynamicEnergyStorage getEnergy() {
        return this.energy;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getOperationTime() {
        if (this.tier == null) {
            return 100;
        }
        return (int)(100.0 * this.tier.getOperationTimeMultiplier());
    }

    public int getFuelLeft() {
        return this.fuelLeft;
    }

    public int getFuelItemValue() {
        return this.fuelItemValue;
    }

    public int getFuelUsage() {
        if (this.tier == null) {
            return 40;
        }
        return (int)(40.0 * this.tier.getFuelUsageMultiplier());
    }

    private BlockPos findNextPosition() {
        int index = this.lastScanIndex + 1;
        int range = this.tier != null ? 1 + this.tier.getAddedRange() : 1;
        int size = range * 2 + 1;
        if (index >= (int)Math.pow(size, 2.0)) {
            index = 0;
        }
        this.lastScanIndex = index;
        int xOffset = index % size - range;
        int zOffset = index / size - range;
        BlockPos center = this.m_58899_().m_5484_(this.direction, range + 1);
        return switch (this.direction) {
            case Direction.NORTH -> new BlockPos(center.m_123341_() + xOffset, center.m_123342_(), center.m_123343_() - zOffset);
            case Direction.SOUTH -> new BlockPos(center.m_123341_() - xOffset, center.m_123342_(), center.m_123343_() + zOffset);
            case Direction.EAST -> new BlockPos(center.m_123341_() + zOffset, center.m_123342_(), center.m_123343_() + xOffset);
            case Direction.WEST -> new BlockPos(center.m_123341_() - zOffset, center.m_123342_(), center.m_123343_() - xOffset);
            default -> center;
        };
    }

    private void addItemToInventory(ItemStack stack, Level level, BlockPos pos) {
        int remaining = stack.m_41613_();
        for (int i = 1; i < this.inventory.getSlots(); ++i) {
            ItemStack stackInSlot = this.inventory.getStackInSlot(i);
            if (stackInSlot.m_41619_()) {
                this.inventory.setStackInSlot(i, stack.m_41777_());
                return;
            }
            if (StackHelper.areStacksEqual((ItemStack)stackInSlot, (ItemStack)stack)) {
                int insertSize = Math.min(remaining, stackInSlot.m_41741_() - stackInSlot.m_41613_());
                this.inventory.setStackInSlot(i, StackHelper.grow((ItemStack)stackInSlot, (int)insertSize));
                remaining -= insertSize;
            }
            if (remaining != 0) continue;
            return;
        }
        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)StackHelper.withSize((ItemStack)stack, (int)remaining, (boolean)false));
    }
}

