/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.compat.jei.category;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crafting.ISouliumSpawnerRecipe;
import com.blakebr0.mysticalagriculture.init.ModBlocks;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class SouliumSpawnerCategory
implements IRecipeCategory<ISouliumSpawnerRecipe> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("mysticalagriculture", "textures/jei/soulium_spawner.png");
    public static final RecipeType<ISouliumSpawnerRecipe> RECIPE_TYPE = RecipeType.create((String)"mysticalagriculture", (String)"soulium_spawner", ISouliumSpawnerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;

    public SouliumSpawnerCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 82, 26);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.REPROCESSOR.get()));
        IDrawableStatic arrow = helper.createDrawable(TEXTURE, 85, 0, 24, 17);
        this.arrow = helper.createAnimatedDrawable(arrow, 100, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<ISouliumSpawnerRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Localizable.of((String)"jei.category.mysticalagriculture.soulium_spawner").build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(ISouliumSpawnerRecipe recipe, IRecipeSlotsView slots, GuiGraphics gfx, double mouseX, double mouseY) {
        this.arrow.draw(gfx, 24, 4);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ISouliumSpawnerRecipe recipe, IFocusGroup focuses) {
        List<ItemStack> inputs = SouliumSpawnerCategory.createInputsList(recipe);
        List<ItemStack> outputs = SouliumSpawnerCategory.createOutputsList(recipe);
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 5).addItemStacks(inputs);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 5).addItemStacks(outputs);
    }

    private static List<ItemStack> createInputsList(ISouliumSpawnerRecipe recipe) {
        return recipe.m_7527_().stream().flatMap(i -> Arrays.stream(i.m_43908_())).map(s -> s.m_255036_(recipe.getInputCount())).toList();
    }

    private static List<ItemStack> createOutputsList(ISouliumSpawnerRecipe recipe) {
        return recipe.getEntityTypes().m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).map(ForgeSpawnEggItem::fromEntityType).filter(Objects::nonNull).map(ItemStack::new).toList();
    }
}

