/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.augment;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.mysticalagriculture.api.lib.AbilityCache;
import com.blakebr0.mysticalagriculture.api.tinkering.Augment;
import com.blakebr0.mysticalagriculture.api.tinkering.AugmentType;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class HealthBoostAugment
extends Augment {
    private static final UUID ATTRIBUTE_ID = UUID.fromString("e04addf9-0fe8-4498-b5a8-45e5201cd76d");
    private final int amplifier;

    public HealthBoostAugment(ResourceLocation id, int tier, int amplifier) {
        super(id, tier, EnumSet.of(AugmentType.ARMOR), HealthBoostAugment.getColor(12984891, tier), HealthBoostAugment.getColor(3867650, tier));
        this.amplifier = amplifier;
    }

    @Override
    public void onPlayerTick(Level level, Player player, AbilityCache cache) {
        if (!cache.isCached(this, player)) {
            AttributeInstance health = player.m_21051_(Attributes.f_22276_);
            if (health == null) {
                return;
            }
            int boost = 4 * this.amplifier;
            AttributeModifier modifier = health.m_22111_(ATTRIBUTE_ID);
            if (modifier != null) {
                if ((double)boost < modifier.m_22218_()) {
                    return;
                }
                health.m_22130_(modifier);
                cache.getCachedAbilities(player).forEach(c -> {
                    Augment augment = AugmentRegistry.getInstance().getAugmentById(new ResourceLocation(c));
                    if (augment instanceof HealthBoostAugment && cache.isCached(augment, player)) {
                        cache.removeQuietly((String)c, player);
                    }
                });
            }
            health.m_22125_(new AttributeModifier(ATTRIBUTE_ID, "mysticalagriculture:health_boost_augment", (double)boost, AttributeModifier.Operation.ADDITION));
            cache.add(this, player, () -> {
                float max = player.m_21233_() - (float)boost;
                if (player.m_21223_() > max) {
                    player.m_21153_(max);
                }
                health.m_22120_(ATTRIBUTE_ID);
            });
        }
    }

    private static int getColor(int color, int tier) {
        return ColorHelper.saturate((int)color, (float)Math.min((float)tier / 5.0f, 1.0f));
    }
}

