/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.item;

import com.google.common.collect.HashBiMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.math.ColorUtils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.LABColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeBottleItem
extends Item {
    public static final String COLOR_TAG = "color";
    protected static final HashBiMap<DyeColor, Integer> COLOR_TO_DIFFUSE = Arrays.stream(DyeColor.values()).collect(Collectors.toMap(Function.identity(), color -> ColorUtils.pack((float[])color.m_41068_()), (color, color2) -> color2, HashBiMap::create));

    public DyeBottleItem(Item.Properties properties) {
        super(properties);
    }

    public static int getColor(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41783_();
        if (compoundTag != null) {
            return compoundTag.m_128451_(COLOR_TAG);
        }
        return 0;
    }

    public static SoftFluidStack toFluidStack(DyeColor color, int amount) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(COLOR_TAG, DyeBottleItem.getDyeInt(color).intValue());
        return SoftFluidStack.of((Holder)ModRegistry.DYE_SOFT_FLUID.getHolder(), (int)amount, (CompoundTag)tag);
    }

    public static ItemStack fromFluidStack(SoftFluidStack stack) {
        ItemStack item = new ItemStack((ItemLike)ModRegistry.DYE_BOTTLE_ITEM.get());
        item.m_41784_().m_128405_(COLOR_TAG, stack.getTag().m_128451_(COLOR_TAG));
        return item;
    }

    public static int mixColor(int oldColor, int newColor, int oldAmount, int newAmount) {
        return new RGBColor(oldColor).asHCL().mixWith(new RGBColor(newColor).asHCL(), (float)newAmount / (float)(oldAmount + newAmount)).asRGB().toInt();
    }

    @NotNull
    private static Integer getDyeInt(DyeColor color) {
        return (Integer)COLOR_TO_DIFFUSE.get((Object)color);
    }

    public static DyeColor getClosestDye(SoftFluidStack stack) {
        return DyeBottleItem.getClosestDye(stack.getTag().m_128451_(COLOR_TAG));
    }

    public static DyeColor getClosestDye(ItemStack stack) {
        return DyeBottleItem.getClosestDye(stack.m_41784_().m_128451_(COLOR_TAG));
    }

    public static DyeColor getClosestDye(int tintColor) {
        LABColor color = new RGBColor(tintColor).asLAB();
        double minDist = Double.MAX_VALUE;
        DyeColor minColor = null;
        for (DyeColor dyeColor : DyeColor.values()) {
            LABColor c2 = new RGBColor(DyeBottleItem.getDyeInt(dyeColor).intValue()).asLAB();
            double dist = c2.distTo((BaseColor)color);
            if (!(dist < minDist)) continue;
            minDist = dist;
            minColor = dyeColor;
        }
        return minColor;
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        stack.m_41784_().m_128405_(COLOR_TAG, DyeBottleItem.getDyeInt(DyeColor.RED).intValue());
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag isAdvanced) {
        CompoundTag tag = stack.m_41784_();
        int col = tag.m_128451_(COLOR_TAG);
        DyeColor color = (DyeColor)COLOR_TO_DIFFUSE.inverse().get((Object)col);
        if (color != null) {
            list.add((Component)Component.m_237115_((String)("item.amendments.dye_bottle." + color.m_41065_())).m_130940_(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.m_237110_((String)"item.color", (Object[])new Object[]{String.format(Locale.ROOT, "#%06X", col)}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, level, list, isAdvanced);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (interactionTarget instanceof Sheep) {
            Sheep sheep = (Sheep)interactionTarget;
            DyeColor dye = DyeBottleItem.getClosestDye(stack);
            if (sheep.m_6084_() && !sheep.m_29875_() && sheep.m_29874_() != dye) {
                sheep.m_9236_().m_6269_(player, (Entity)sheep, SoundEvents.f_144133_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_9236_().f_46443_) {
                    sheep.m_29855_(dye);
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)player.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }
}

