/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.controller;

import com.yogpc.qp.Holder;
import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.QPBlock;
import com.yogpc.qp.machines.controller.ControllerOpenMessage;
import com.yogpc.qp.packet.PacketHandler;
import com.yogpc.qp.utils.MapMulti;
import cpw.mods.modlauncher.Launcher;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Logger;

public class BlockController
extends QPBlock {
    public static final String NAME = "spawner_controller";
    private static final Logger LOGGER = QuarryPlus.getLogger(BlockController.class);
    private static final Field logic_spawnDelay = BlockController.getSpawnDelayField();
    private static final Field logic_nextSpawnData = BlockController.getNextSpawnDataField();

    public BlockController() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283808_).m_278166_(PushReaction.DESTROY).m_60966_().m_60978_(1.0f), NAME);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{WORKING});
    }

    private static Optional<Pair<BaseSpawner, BlockPos>> getSpawner(Level level, BlockPos pos) {
        return Stream.of(Direction.values()).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).map(arg_0 -> ((Level)level).m_7702_(arg_0)).mapMulti(MapMulti.cast(SpawnerBlockEntity.class)).map(s -> Pair.of((Object)s.m_59801_(), (Object)s.m_58899_())).findFirst();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!QuarryPlus.config.enableMap.enabled(NAME)) {
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237110_((String)"quarryplus.chat.disable_message", (Object[])new Object[]{this.m_49954_()}), true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (!player.m_6144_()) {
            if (!level.f_46443_) {
                if (player.m_21120_(hand).m_150930_((Item)Holder.ITEM_CHECKER)) {
                    BlockController.getSpawner(level, pos).map(Pair::getLeft).flatMap(BlockController::getEntityId).map(ResourceLocation::toString).map(s -> "Spawner Mob: " + s).map(Component::m_237113_).ifPresent(s -> player.m_5661_((Component)s, false));
                } else {
                    List<ResourceLocation> entries = ForgeRegistries.ENTITY_TYPES.getValues().stream().filter(BlockController::canSpawnFromSpawner).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0)).collect(Collectors.toList());
                    PacketHandler.sendToClientPlayer(new ControllerOpenMessage(pos, (ResourceKey<Level>)level.m_46472_(), entries), (ServerPlayer)player);
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    private static Optional<ResourceLocation> getEntityId(BaseSpawner spawner) {
        try {
            return Optional.ofNullable(logic_nextSpawnData.get(spawner)).flatMap(MapMulti.optCast(SpawnData.class)).map(SpawnData::m_186567_).flatMap(EntityType::m_20637_).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getKey(arg_0));
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Exception occurred in getting entity id.", (Throwable)e);
            return Optional.empty();
        }
    }

    private static boolean canSpawnFromSpawner(EntityType<?> entityType) {
        if (QuarryPlus.config == null) {
            return true;
        }
        if (!entityType.m_20654_()) {
            return false;
        }
        return !((List)QuarryPlus.config.common.spawnerBlackList.get()).contains(String.valueOf(ForgeRegistries.ENTITY_TYPES.getKey(entityType)));
    }

    public static void setSpawnerEntity(Level world, BlockPos pos, ResourceLocation name) {
        BlockController.getSpawner(world, pos).ifPresent(logic -> {
            Optional.of(name).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.ENTITY_TYPES).getValue(arg_0)).filter(BlockController::canSpawnFromSpawner).ifPresent(entityType -> ((BaseSpawner)logic.getLeft()).m_253197_(entityType, world, world.m_213780_(), pos));
            Optional.ofNullable(((BaseSpawner)logic.getLeft()).getSpawnerBlockEntity()).ifPresent(BlockEntity::m_6596_);
            BlockState state = world.m_8055_((BlockPos)logic.getRight());
            world.m_7260_((BlockPos)logic.getRight(), state, state, 4);
        });
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_ && QuarryPlus.config.enableMap.enabled(NAME)) {
            boolean powered = level.m_276867_(pos);
            boolean m = (Boolean)state.m_61143_((Property)QPBlock.WORKING);
            if (powered && !m) {
                BlockController.getSpawner(level, pos).ifPresent(logic -> {
                    try {
                        logic_spawnDelay.setInt(logic.getLeft(), 0);
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.warn((Object)e);
                        return;
                    }
                    FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                    fakePlayer.m_6034_((double)((BlockPos)logic.getRight()).m_123341_(), (double)((BlockPos)logic.getRight()).m_123342_(), (double)((BlockPos)logic.getRight()).m_123343_());
                    ((BaseSpawner)logic.getLeft()).m_151311_((ServerLevel)level, (BlockPos)logic.getRight());
                });
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)QPBlock.WORKING, (Comparable)Boolean.valueOf(powered)), 3);
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    private static Field getSpawnDelayField() {
        if (Launcher.INSTANCE != null) {
            return ObfuscationReflectionHelper.findField(BaseSpawner.class, (String)"f_45442_");
        }
        try {
            Field f = BaseSpawner.class.getDeclaredField("spawnDelay");
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Field getNextSpawnDataField() {
        if (Launcher.INSTANCE != null) {
            return ObfuscationReflectionHelper.findField(BaseSpawner.class, (String)"f_45444_");
        }
        try {
            Field f = BaseSpawner.class.getDeclaredField("nextSpawnData");
            f.setAccessible(true);
            return f;
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

