/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record ItemKey(Item item, @Nullable CompoundTag nbt) {
    public static final ItemKey EMPTY_KEY = new ItemKey(ItemStack.f_41583_);

    public ItemKey(ItemStack stack) {
        this(stack.m_41720_(), stack.m_41783_());
    }

    public CompoundTag createNbt(long itemCount) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("item", this.getId().toString());
        if (this.nbt != null) {
            tag.m_128365_("tag", (Tag)this.nbt);
        }
        tag.m_128356_("count", itemCount);
        return tag;
    }

    public CompoundTag createNbt() {
        return this.createNbt(1L);
    }

    public static ItemKey fromNbt(CompoundTag tag) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.m_128461_("item")));
        CompoundTag nbt = tag.m_128441_("tag") ? tag.m_128469_("tag") : null;
        return new ItemKey(item, nbt);
    }

    public ItemStack toStack(int count) {
        ItemStack stack = new ItemStack((ItemLike)this.item, count);
        stack.m_41751_(this.nbt);
        return stack;
    }

    public ResourceLocation getId() {
        return ForgeRegistries.ITEMS.getKey((Object)this.item);
    }
}

