/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.plugin;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.api.movement.MovementPlugin;
import tictim.paraglider.api.movement.MovementPluginAction;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.api.plugin.ConflictResolver;
import tictim.paraglider.api.plugin.ParagliderPlugin;
import tictim.paraglider.api.stamina.Stamina;
import tictim.paraglider.config.Cfg;
import tictim.paraglider.wind.Wind;

@ParagliderPlugin
public class ParagliderDefaultPlugin
implements MovementPlugin {
    private static final ConflictResolver<MovementPlugin, MovementPluginAction> RESOLVER = (a, p) -> {
        if (a instanceof MovementPluginAction.NewState) {
            return ConflictResolver.Resolution.PROCEED;
        }
        return ConflictResolver.Resolution.ABORT;
    };

    @Override
    public void registerNewStates(@NotNull MovementPlugin.PlayerStateRegister register) {
        register.register(ParagliderPlayerStates.IDLE, 20, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.FLYING, 20, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.ON_VEHICLE, 20, new ResourceLocation[0]);
        register.register(ParagliderPlayerStates.SWIMMING, -6, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.UNDERWATER, 3, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.BREATHING_UNDERWATER, 20, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.PARAGLIDING, -3, ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        register.register(ParagliderPlayerStates.PANIC_PARAGLIDING, -3, ParagliderPlayerStates.Flags.FLAG_PARAGLIDING);
        register.register(ParagliderPlayerStates.ASCENDING, -3, ParagliderPlayerStates.Flags.FLAG_PARAGLIDING, ParagliderPlayerStates.Flags.FLAG_ASCENDING);
        register.register(ParagliderPlayerStates.RUNNING, -10, ParagliderPlayerStates.Flags.FLAG_RUNNING);
        register.register(ParagliderPlayerStates.MIDAIR, 0, new ResourceLocation[0]);
    }

    @Override
    public void registerStateConnections(@NotNull MovementPlugin.PlayerStateConnectionRegister register) {
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.m_150110_().f_35935_ || p.m_21255_(), ParagliderPlayerStates.FLYING, 7.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.m_20202_() != null, ParagliderPlayerStates.ON_VEHICLE, 6.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.m_6069_(), ParagliderPlayerStates.SWIMMING, 5.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.m_20069_(), ParagliderPlayerStates.UNDERWATER, 4.0);
        register.addBranch(ParagliderPlayerStates.UNDERWATER, (p, s, b, f) -> ParagliderUtils.canBreatheUnderwater(p), ParagliderPlayerStates.BREATHING_UNDERWATER);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> {
            Paraglider item;
            Item patt2617$temp;
            return b && !p.m_20096_() && !p.m_21255_() && (patt2617$temp = p.m_21205_().m_41720_()) instanceof Paraglider && (item = (Paraglider)patt2617$temp).canDoParagliding(p.m_21205_());
        }, ParagliderPlayerStates.PARAGLIDING, 3.0);
        register.addBranch(ParagliderPlayerStates.PARAGLIDING, (p, s, b, f) -> f >= (double)1.45f && !p.m_7500_() && Stamina.get(p).isDepleted(), ParagliderPlayerStates.PANIC_PARAGLIDING);
        register.addBranch(ParagliderPlayerStates.PARAGLIDING, (p, s, b, f) -> Cfg.get().ascendingWinds() && Wind.isInside(p.m_9236_(), p.m_20191_()), ParagliderPlayerStates.ASCENDING);
        register.addBranch(ParagliderPlayerStates.PARAGLIDING, (p, s, b, f) -> f < (double)1.45f && !s.has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING), ParagliderPlayerStates.IDLE);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> p.m_20142_() && !p.m_6117_(), ParagliderPlayerStates.RUNNING, 2.0);
        register.addBranch(ParagliderPlayerStates.IDLE, (p, s, b, f) -> !p.m_20096_(), ParagliderPlayerStates.MIDAIR, 1.0);
    }

    @Override
    @NotNull
    public ConflictResolver<MovementPlugin, MovementPluginAction> getMovementPluginConflictResolver() {
        return RESOLVER;
    }
}

