/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.forge.event;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.api.movement.Movement;
import tictim.paraglider.api.movement.ParagliderPlayerStates;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.forge.capability.PlayerMovementProvider;
import tictim.paraglider.impl.movement.PlayerMovement;
import tictim.paraglider.impl.movement.ServerPlayerMovement;
import tictim.paraglider.network.ParagliderNetwork;

@Mod.EventBusSubscriber(modid="paraglider")
public final class ParagliderEventHandler {
    private static final ResourceLocation MOVEMENT_HANDLER_KEY = ParagliderAPI.id("paragliding_movement_handler");

    private ParagliderEventHandler() {
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        Movement movement;
        if (event.isCancelable() && event.getHand() == InteractionHand.OFF_HAND && (movement = Movement.get(event.getEntity())).state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerStartUseItem(LivingEntityUseItemEvent.Start event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Movement movement = Movement.get(player);
        if (movement.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickUseItem(LivingEntityUseItemEvent.Tick event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Movement movement = Movement.get(player);
        if (movement.state().has(ParagliderPlayerStates.Flags.FLAG_PARAGLIDING)) {
            player.m_5810_();
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        PlayerMovement m2;
        Player original = event.getOriginal();
        original.reviveCaps();
        PlayerMovement m1 = PlayerMovementProvider.of((ICapabilityProvider)original);
        if (m1 != null && (m2 = PlayerMovementProvider.of((ICapabilityProvider)event.getEntity())) != null) {
            m2.copyFrom(m1);
            if (event.isWasDeath()) {
                m2.stamina().setStamina(m2.stamina().maxStamina());
            }
        }
        original.invalidateCaps();
    }

    @SubscribeEvent
    public static void onAttachPlayerCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (!(object instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        event.addCapability(MOVEMENT_HANDLER_KEY, (ICapabilityProvider)PlayerMovementProvider.create(ParagliderUtils.createPlayerMovement(player)));
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Movement movement = Movement.get(event.player);
        if (movement instanceof PlayerMovement) {
            PlayerMovement playerMovement = (PlayerMovement)movement;
            playerMovement.update();
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player tracking;
        Entity entity;
        block3: {
            block2: {
                entity = event.getTarget();
                if (!(entity instanceof Player)) break block2;
                tracking = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof ServerPlayer) break block3;
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        ParagliderNetwork.get().syncRemoteMovement((Entity)tracking, player, Movement.get(tracking).state().id());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Movement movement = Movement.get(event.getEntity());
        if (movement instanceof ServerPlayerMovement) {
            ServerPlayerMovement serverPlayerMovement = (ServerPlayerMovement)movement;
            serverPlayerMovement.markForSync();
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            BargainHandler.update();
        }
    }

    @SubscribeEvent
    public static void onLogin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ParagliderNetwork.get().syncStateMap(player2, ParagliderMod.instance().getLocalPlayerStateMap());
        }
    }
}

