/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents.worldgen;

import com.mojang.serialization.Codec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.api.ParagliderAPI;
import tictim.paraglider.contents.Contents;
import tictim.paraglider.contents.worldgen.BaseHornedStatuePiece;

public class UndergroundHornedStatue
extends Structure {
    public static final Codec<UndergroundHornedStatue> CODEC = UndergroundHornedStatue.m_226607_(UndergroundHornedStatue::new);
    private static final ResourceLocation TEMPLATE = ParagliderAPI.id("underground_horned_statue");

    @NotNull
    public static StructurePieceType.StructureTemplateType pieceType() {
        return BaseHornedStatuePiece.createType(() -> Contents.get().undergroundHornedStatuePiece(), BlockPos.f_121853_);
    }

    public UndergroundHornedStatue(@NotNull Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(@NotNull Structure.GenerationContext ctx) {
        int z;
        int x = ctx.f_226628_().m_45604_() + ctx.f_226626_().m_188503_(16);
        int y = UndergroundHornedStatue.searchY(ctx, x, z = ctx.f_226628_().m_45605_() + ctx.f_226626_().m_188503_(16));
        if (y == Integer.MIN_VALUE) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        Rotation rotation = Rotation.m_221990_((RandomSource)ctx.f_226626_());
        return Optional.of(new Structure.GenerationStub(pos, b -> b.m_142679_((StructurePiece)new BaseHornedStatuePiece(Contents.get().undergroundHornedStatuePiece(), ctx.f_226625_(), TEMPLATE, pos).rot(BlockPos.f_121853_, rotation))));
    }

    private static int searchY(@NotNull Structure.GenerationContext ctx, int x, int z) {
        int y;
        int depth = 17;
        NoiseColumn col = ctx.f_226622_().m_214184_(x, z, ctx.f_226629_(), ctx.f_226624_());
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos(x, y, z);
        for (y = ctx.f_226622_().m_223235_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, ctx.f_226629_(), ctx.f_226624_()) - ctx.f_226626_().m_188503_(30); y > -32; --y) {
            BlockState state = col.m_183556_(y);
            if (state.m_60812_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mpos.m_142448_(y)).m_83281_()) {
                if (depth >= 5) continue;
                depth = 5;
                continue;
            }
            if (--depth > 0) continue;
            return y;
        }
        return Integer.MIN_VALUE;
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return Contents.get().undergroundHornedStatue();
    }

    @NotNull
    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }
}

